//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsLayer_c.h, C++ API dsLayer_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"
#include "dsConstants.h"

class dsLayer_p;
class dsLayer;
class dsColor_c;
class dsCustomData_c;
class dsDictionary_c;
class dsViewport_c;
class DSINTERFACE_EXPORT dsLayer_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsLayer)
public:
	DSRESULT IsSame(dsLayer_c* dsObj);
	DSRESULT get_Name(dsString* Val);
	DSRESULT get_Shown(bool* Val);
	DSRESULT put_Shown(bool NewVal);
	DSRESULT get_Frozen(bool* Val);
	DSRESULT put_Frozen(bool NewVal);
	DSRESULT get_Locked(bool* Val);
	DSRESULT put_Locked(bool NewVal);
	DSRESULT get_Printable(bool* Val);
	DSRESULT put_Printable(bool NewVal);
	DSRESULT get_LineStyle(dsString* Val);
	DSRESULT put_LineStyle(const dsString& NewVal);
	DSRESULT get_LineWeight(dsLineWeight_e* Val);
	DSRESULT put_LineWeight(dsLineWeight_e NewVal);
	DSRESULT get_PrintStyle(dsString* Val);
	DSRESULT put_PrintStyle(const dsString& NewVal);
	DSRESULT get_Description(dsString* Val);
	DSRESULT put_Description(const dsString& NewVal);
	DSRESULT Rename(const dsString& Name, dsCreateObjectResult_e* Result);
	DSRESULT Activate(bool* Result);
	DSRESULT get_Color(dsColor_c ** Val);
	DSRESULT put_Color(dsColor_c * NewVal);
	DSRESULT GetCustomData(const dsString&  ApplicationName, dsCustomData_c ** CustomData);
	DSRESULT SetCustomData(const dsString&  ApplicationName, dsCustomData_c * CustomData);
	DSRESULT DeleteCustomData(const dsString&  ApplicationName);
	DSRESULT get_Handle(dsString*  Val);
	DSRESULT CreateExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT GetExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT ReleaseExtensionDictionary(bool * Result);
	DSRESULT get_Transparency(long * Val );
	DSRESULT put_Transparency(long  NewVal);
	DSRESULT get_FrozenInNewViewport(  bool* Val );
	DSRESULT put_FrozenInNewViewport(  bool NewVal );
	DSRESULT GetFrozenInViewport(dsViewport_c  *  Viewport, bool * IsFrozen);
	DSRESULT SetFrozenInViewport(bool  IsFrozen, dsViewport_c  * Viewport);
	DSRESULT GetColorInViewport(dsViewport_c * Viewport, bool * IsOverride, dsColor_c ** Color);
	DSRESULT SetColorInViewport(dsColor_c * Color, dsViewport_c  * Viewport);
	DSRESULT GetLineSyleInViewport(dsViewport_c  * Viewport, bool * IsOverride, dsString*  LineStyle);
	DSRESULT SetLineStyleInViewport(const dsString&  LineStyle, dsViewport_c  * Viewport);
	DSRESULT GetLineWeightInViewport(dsViewport_c  * Viewport, bool * IsOverride, dsLineWeight_e*  LineWeight);
	DSRESULT SetLineWeightInViewport(dsLineWeight_e  LineWeight, dsViewport_c  * Viewport);
	DSRESULT GetTranparencyInViewport(dsViewport_c  * Viewport, bool * IsOverride, long * Transparency);
	DSRESULT SetTranparencyInViewport(long  Transparency, dsViewport_c  * Viewport);
	DSRESULT GetPrintStyleInViewport(dsViewport_c  * Viewport, bool * IsOverride, dsString*  PrintStyle);
	DSRESULT SetPrintStyleInViewport(const dsString&  PrintStyle, dsViewport_c  * Viewport);
	DSRESULT RemoveColorOverrides( );
	DSRESULT RemoveColorOverride(dsViewport_c * Viewport);
	DSRESULT RemoveLineStyleOverrides( );
	DSRESULT RemoveLineStyleOverride(dsViewport_c * Viewport);
	DSRESULT RemoveLineWeightOverrides( );
	DSRESULT RemoveLineWeightOverride(dsViewport_c * Viewport);
	DSRESULT RemoveTransparencyOverrides( );
	DSRESULT RemoveTransparencyOverride(dsViewport_c * Viewport);
	DSRESULT RemovePrintStyleOverrides( );
	DSRESULT RemovePrintStyleOverride(dsViewport_c * Viewport);
};
