//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2011 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsLayerStateManager_c.h, C++ API dsLayerStateManager_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"

class dsLayerStateManager_p;
class dsLayerStateManager;
class dsLayerState;
class dsLayerState_c;
class DSINTERFACE_EXPORT dsLayerStateManager_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsLayerStateManager)
public:
	DSRESULT IsSame(dsLayerStateManager_c* dsObj);

	DSRESULT GetLayerStates(dsObjectPtrArray* LayerStatesArray);
	DSRESULT RemoveLayerState(const dsString&  LayerStateName, bool * Result);
	DSRESULT CreateLayerState(const dsString&  LayerStateName, dsLayerStateSpaceType_e  LayerStateType, dsLayerState_c ** LayerState, dsCreateObjectResult_e* Result);
	DSRESULT GetActiveLayerState(dsLayerState_c ** LayerState);
	DSRESULT ImportLayerState(const dsString&  FilePathName, bool Overwrite, dsLayerState_c ** LayerState);
	DSRESULT ExportLayerState(const dsString&  LayerStateName, const dsString&  FilePathName, bool * Result);
	DSRESULT get_HideLayersNotAssignedToLayerState(bool * Val);
	DSRESULT put_HideLayersNotAssignedToLayerState(bool  NewVal);
	DSRESULT get_SetPropertiesAsViewPortOverrides(bool * Val);
	DSRESULT put_SetPropertiesAsViewPortOverrides(bool  NewVal);
	DSRESULT GetLayerState(const dsString&  LayerStateName, dsLayerState_c ** LayerState);
};
