//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsJoggedDimension_c.h, C++ API dsJoggedDimension_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"

class dsJoggedDimension_p;
class dsJoggedDimension;
class dsGeneralDimension_c;
class DSINTERFACE_EXPORT dsJoggedDimension_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsJoggedDimension)
public:
	DSRESULT IsSame(dsJoggedDimension_c* dsObj);

	DSRESULT GetGeneralDimension(dsGeneralDimension_c ** GeneralDimension);
	DSRESULT GetChordPoint(double * X, double * Y, double * Z);
	DSRESULT SetChordPoint(double  X, double  Y, double  Z);
	DSRESULT GetCenterPoint(double * X, double * Y, double * Z);
	DSRESULT SetCenterPoint(double  X, double  Y, double  Z);
	DSRESULT GetOverrideCenterPoint(double * X, double * Y, double * Z);
	DSRESULT SetOverrideCenterPoint(double  X, double  Y, double  Z);
	DSRESULT GetJogPoint(double * X, double * Y, double * Z);
	DSRESULT SetJogPoint(double  X, double  Y, double  Z);
	DSRESULT get_JogAngle(double * Val);
	DSRESULT put_JogAngle(double  NewVal);
};
