//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsHyperLink_c.h, C++ API dsHyperLink_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"

class dsHyperLink_p;
class dsHyperLink;
class DSINTERFACE_EXPORT dsHyperLink_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsHyperLink)
public:
	DSRESULT IsSame(dsHyperLink_c* dsObj);

	DSRESULT GetType(dsHyperLinkType_e* LinkType);
	DSRESULT get_Description(dsString*  Val);
	DSRESULT put_Description(const dsString&  NewVal);
	//DSRESULT GetVisibleString(dsString*  VisibleString);
	DSRESULT GetAsFileOrWebPage(dsString*  Destination, dsString* Sublocation, bool * Result);
	DSRESULT SetFileOrWebPage(const dsString&  Destination, const dsString& Sublocation);
	DSRESULT GetAsPlaceInThisDrawing(dsString*  PlaceInDrawing, bool * Result);
	DSRESULT SetPlaceInThisDrawing(const dsString&  PlaceInDrawing);
	DSRESULT GetAsEmailAddress(dsString*  EmailAddress, dsString*  Subject, bool * Result);
	DSRESULT SetEmailAddress(const dsString&  EmailAddress, const dsString&  Subject);
	DSRESULT GetRawData(dsString*  Address, dsString* Sublocation, dsString* Description);
};
