//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2011 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsHighlightSet_c.h, C++ API dsHighlightSet_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsLongArray.h"

class dsHighlightSet_p;
class dsHighlightSet;
class DSINTERFACE_EXPORT dsHighlightSet_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsHighlightSet)
public:
	DSRESULT IsSame(dsHighlightSet_c* dsObj);

	DSRESULT get_Highlight(bool * Val);
	DSRESULT put_Highlight(bool  NewVal);
	DSRESULT AddEntities(const dsObjectPtrArray&  EntitiesArray);
	DSRESULT RemoveEntities(const dsObjectPtrArray&  EntitiesArray);
	DSRESULT HasEntity(dsObject * Entity , bool * HasEntity);
	DSRESULT GetEntities(dsLongArray* EntityTypeLongArray, dsObjectPtrArray *EntitiesArray);
};
