//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsHatchPattern_c.h, C++ API dsHatchPattern_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"

class dsHatchPattern_p;
class dsHatchPattern;
class dsColor_c;
class DSINTERFACE_EXPORT dsHatchPattern_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsHatchPattern)
public:
	DSRESULT IsSame(dsHatchPattern_c* dsObj);

	DSRESULT get_Associative(bool * Val);
	DSRESULT DropAssociative( );
	DSRESULT get_InternalRegionDetection(dsHatchPatternInternalRegionDetection_e* Val);
	DSRESULT put_InternalRegionDetection(dsHatchPatternInternalRegionDetection_e NewVal);
	DSRESULT GetOrigin(double * X, double * Y);
	DSRESULT SetOrigin(double  X, double  Y);
	DSRESULT GetHatchOrSolidData(dsString*  PatternName, double * Angle, double * Scale, dsHatchPatternType_e* HatchPatternType, double * Spacing);
	DSRESULT GetGradientData(dsColor_c ** Color1, dsColor_c ** Color2, bool * IsCentered, double * GradientAngle);
	DSRESULT SetHatchOrSolidData(const dsString&  PatternName, double  Angle, double  Scale, dsHatchPatternType_e HatchPatternType, double  Spacing);
	DSRESULT SetGradientData(dsColor_c * Color1, dsColor_c * Color2, bool  IsCentered, double  GradientAngle);
	DSRESULT GetFillType(dsHatchFillType_e* FillType);
	DSRESULT GetGradientStyle(dsHatchGradientStyle_e*   GradientStyle);
	DSRESULT SetGradientStyle(dsHatchGradientStyle_e   GradientStyle);
};
