//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2011 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsExportSettings_c.h, C++ API dsExportSettings_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"

class dsExportSettings_p;
class dsExportSettings;
class DSINTERFACE_EXPORT dsExportSettings_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsExportSettings)
public:
	DSRESULT IsSame(dsExportSettings_c* dsObj);

	DSRESULT GetAvailablePaperSizes( dsStringArray* PaperSizesStrArray);
	DSRESULT GetPrintMargins(double * Top, double * Bottom, double * Left, double * Right);
	DSRESULT SetPrintMargins(double Top, double Bottom, double Left, double Right);
	DSRESULT get_Sheets( dsStringArray*  Val);
	DSRESULT put_Sheets(const dsStringArray &  NewVal);
	DSRESULT get_PrintStyleTable(dsString*  Val);
	DSRESULT put_PrintStyleTable(const dsString&  NewVal);
	DSRESULT get_EnableLayersInPDFFile(bool*  Val);
	DSRESULT put_EnableLayersInPDFFile(bool  NewVal);
	DSRESULT get_EnableCustomBitmapResolution(bool*  Val);
	DSRESULT put_EnableCustomBitmapResolution(bool  NewVal);
	DSRESULT get_CustomBitmapResolution(double * Val);
	DSRESULT put_CustomBitmapResolution(double  NewVal);
	DSRESULT get_TrueTypeFontsType(dsTrueTypeFontsType_e*  Val);
	DSRESULT put_TrueTypeFontsType(dsTrueTypeFontsType_e  NewVal);
	DSRESULT get_TrueTypeFontsOptimized(bool * Val);
	DSRESULT put_TrueTypeFontsOptimized(bool  NewVal);
	DSRESULT get_PaperSize(dsString*  Val);
	DSRESULT put_PaperSize(const dsString&  NewVal);
	DSRESULT get_DocumentAuthor(dsString*  Val);
	DSRESULT put_DocumentAuthor(const dsString&  NewVal);
	DSRESULT get_DocumentKeywords(dsString*  Val);
	DSRESULT put_DocumentKeywords(const dsString&  NewVal);
	DSRESULT get_DocumentTitle(dsString*  Val);
	DSRESULT put_DocumentTitle(const dsString&  NewVal);
	DSRESULT get_DocumentSubject(dsString*  Val);
	DSRESULT put_DocumentSubject(const dsString&  NewVal);
	DSRESULT get_EnableSaveToPDFDocumentPropertiesData(bool * Val);
	DSRESULT put_EnableSaveToPDFDocumentPropertiesData(bool  NewVal);
	DSRESULT get_EnableSaveBackToDrawingPropertiesData(bool * Val);
	DSRESULT put_EnableSaveBackToDrawingPropertiesData(bool  NewVal);
};
