//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsDimensionStyleLinearDimensionOptions_c.h, C++ API dsDimensionStyleLinearDimensionOptions_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"

class dsDimensionStyleLinearDimensionOptions_p;
class dsDimensionStyleLinearDimensionOptions;
class DSINTERFACE_EXPORT dsDimensionStyleLinearDimensionOptions_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsDimensionStyleLinearDimensionOptions)
public:
	DSRESULT IsSame(dsDimensionStyleLinearDimensionOptions_c* dsObj);

	DSRESULT get_Format(dsLinearDimensionFormat_e* Val);
	DSRESULT put_Format(dsLinearDimensionFormat_e NewVal);
	DSRESULT get_Precision(dsUnitPrecision_e* Val);
	DSRESULT put_Precision(dsUnitPrecision_e NewVal);
	DSRESULT get_FractionalDisplay(dsLinearDimensionFractionalDisplay_e* Val);
	DSRESULT put_FractionalDisplay(dsLinearDimensionFractionalDisplay_e NewVal);
	DSRESULT get_DecimalSeparator(dsLinearDimensionDecimalSeparator_e* Val);
	DSRESULT put_DecimalSeparator(dsLinearDimensionDecimalSeparator_e NewVal);
	DSRESULT get_RoundToTheNearest(double * Val);
	DSRESULT put_RoundToTheNearest(double  NewVal);
	DSRESULT get_Prefix(dsString*  Val);
	DSRESULT put_Prefix(const dsString&  NewVal);
	DSRESULT get_Suffix(dsString*  Val);
	DSRESULT put_Suffix(const dsString&  NewVal);
	DSRESULT get_MeasurementScaleFactor(double * Val);
	DSRESULT put_MeasurementScaleFactor(double  NewVal);
	DSRESULT get_ZeroesDisplayFollowSheetDimensions(bool * Val);
	DSRESULT put_ZeroesDisplayFollowSheetDimensions(bool  NewVal);
	DSRESULT get_HideLeadingZeroes(bool * Val);
	DSRESULT put_HideLeadingZeroes(bool  NewVal);
	DSRESULT get_HideTrailingZeroes(bool * Val);
	DSRESULT put_HideTrailingZeroes(bool  NewVal);
	DSRESULT get_HideZeroesIf0Feet(bool * Val);
	DSRESULT put_HideZeroesIf0Feet(bool  NewVal);
	DSRESULT get_HideZeroesIf0Inches(bool * Val);
	DSRESULT put_HideZeroesIf0Inches(bool  NewVal);
};
