//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsDimensionStyleFitOptions_c.h, C++ API dsDimensionStyleFitOptions_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"

class dsDimensionStyleFitOptions_p;
class dsDimensionStyleFitOptions;
class DSINTERFACE_EXPORT dsDimensionStyleFitOptions_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsDimensionStyleFitOptions)
public:
	DSRESULT IsSame(dsDimensionStyleFitOptions_c* dsObj);

	DSRESULT get_HideArrows(bool * Val);
	DSRESULT put_HideArrows(bool  NewVal);
	DSRESULT get_FitGeometry(dsDimensionFitGeometry_e* Val);
	DSRESULT put_FitGeometry(dsDimensionFitGeometry_e NewVal);
	DSRESULT get_FitDimensionText(dsDimensionFitDimensionText_e* Val);
	DSRESULT put_FitDimensionText(dsDimensionFitDimensionText_e NewVal);
	DSRESULT GetDimensionScale(dsDimensionScale_e* DimensionScaleMethod, double * ScaleFactor);
	DSRESULT SetDimensionScale(dsDimensionScale_e DimensionScaleMethod, double  ScaleFactor);
	DSRESULT get_DimensionLinesBetweenExtensionLine(bool * Val);
	DSRESULT put_DimensionLinesBetweenExtensionLine(bool  NewVal);
	DSRESULT get_SpecifyTextPlacement(bool * Val);
	DSRESULT put_SpecifyTextPlacement(bool  NewVal);
};
