//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2011 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsDictionary_c.h, C++ API dsDictionary_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"

class dsDictionary_p;
class dsDictionary;
class dsCustomData_c;
class dsXRecord_c;
class dsDictionary_c;
class DSINTERFACE_EXPORT dsDictionary_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsDictionary)
public:
	DSRESULT IsSame(dsDictionary_c* dsObj);

	DSRESULT CreateDictionary(const dsString&  Name, dsDictionary_c ** Dictionary);
	DSRESULT GetEntry(const dsString&  Name, dsObjectType_e*  ObjType, dsObject ** Obj);
	DSRESULT SetEntry(const dsString&  Name, dsObject * Obj);
	DSRESULT HasEntry(const dsString&  Name, bool * HasEntry);
	DSRESULT RemoveEntry(const dsString&  Name);
	DSRESULT GetNameOf(dsObject * Entity, dsString*  Name);
	DSRESULT RenameEntry(const dsString&  OldName, const dsString&  NewName, bool * Result);
	DSRESULT GetEntries(dsLongArray* EntityTypeLongArray, dsObjectPtrArray * EntitiesArray);
	DSRESULT GetCustomData(const dsString&  ApplicationName, dsCustomData_c ** CustomData);
	DSRESULT SetCustomData(const dsString&  ApplicationName, dsCustomData_c * CustomData);
	DSRESULT DeleteCustomData(const dsString&  ApplicationName);
	DSRESULT get_Handle(dsString*  Val);
	DSRESULT CreateXRecord(const dsString&  Name, dsXRecord_c ** XRecord);
	DSRESULT CreateExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT GetExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT ReleaseExtensionDictionary(bool * Result);
	DSRESULT get_Erased(bool * Val);
	DSRESULT put_Erased(bool  NewVal);
};
