//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsCommand_c.h, C++ API dsCommand_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"

class dsCommand_p;
class dsCommand;
class DSINTERFACE_EXPORT dsCommand_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsCommand)
public:
	DSRESULT RegisterEvent(dsCommandEvent_id_e eventId, void* eventClassPtr, void *eventFuncPtr);
	DSRESULT UnRegisterEvent(dsCommandEvent_id_e eventId, void* eventClassPtr, void *eventFuncPtr);
	DSRESULT IsSame(dsCommand_c* Obj);

	DSRESULT GetApiID(dsString* Uuid);
	DSRESULT GetName(dsString* CmdName);
    DSRESULT GetGlobalName(dsString* GlobalName);
	DSRESULT get_LastError(dsRunCommandError_e* Val);
	DSRESULT put_LastError(dsRunCommandError_e NewVal);
};

class dsCommandEvents_c
{
public:

	virtual bool ExecuteNotify(void) {return true;}
};

#define DeclareCommandExecuteNotifyHook static bool ExecuteNotifyHook(void* eventClassPtr);

#define ImplementCommandExecuteNotifyHook(EventClass)\
bool EventClass ::ExecuteNotifyHook(void* eventClassPtr) \
{ \
	return ((EventClass *) eventClassPtr)->ExecuteNotify(); \
}

#define RegisterCommandExecuteNotifyHook(dsObject)\
        dsObject->RegisterEvent(dsCommand_ExecuteNotify_id, this, reinterpret_cast< void * >( ExecuteNotifyHook ) );

#define UnRegisterCommandExecuteNotifyHook(dsObject)\
        dsObject->UnRegisterEvent(dsCommand_ExecuteNotify_id, this, reinterpret_cast< void * >( ExecuteNotifyHook ));
