//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsColor_c.h, C++ API dsColor_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"

class dsColor;
class dsColor_p;
class DSINTERFACE_EXPORT dsColor_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsColor)
public:
	DSRESULT IsSame(dsColor_c* dsObj);

	DSRESULT IsNamedColor(bool * Result);
	DSRESULT IsColorByIndex(bool * Result);
	DSRESULT GetNamedColor(dsNamedColor_e* Result);
	DSRESULT GetColorIndex( long* Index);
	DSRESULT GetRGB( long* Red,  long* Green,  long* Blue);
	DSRESULT SetNamedColor(dsNamedColor_e NamedColor);
	DSRESULT SetColorByIndex( long Index);
	DSRESULT SetRGBColor( long Red,  long Green,  long Blue);
	DSRESULT SetByColor(dsColor_c * InColor);
	//DSRESULT IsEquivalent(dsColor_c * OtherColor, bool * Result);
};
