//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsCCSManager_c.h, C++ API dsCCSManager_c interface
//

#pragma once

#include "dsInterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsStringArray.h"

class dsCCSManager_p;
class dsCCSManager;
class dsCCS_c;
class DSINTERFACE_EXPORT dsCCSManager_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsCCSManager)
public:
	DSRESULT IsSame(dsCCSManager_c* dsObj);

	DSRESULT GetWorldCCS(dsCCS_c ** CCS);
	DSRESULT GetPreviousCCS(dsCCS_c ** CCS);
	DSRESULT GetNamedCCSList(dsStringArray * CCSNamesStrArray);
	DSRESULT GetNamedCCS(const dsString&  CSSName, dsCCS_c ** CCS);
	DSRESULT RemoveCSS(const dsString&  CCSName, bool * Result);
	DSRESULT GetActiveCCS(dsCCS_c ** CCS);
	DSRESULT GetDafaultCSS(dsDefaultCSS_e DefaultCSS, dsCCS_c ** CCS);
	DSRESULT AlignActiveCSSByEntity(dsObjectType_e EntityType, dsObject * Entity);
	DSRESULT AlignActiveCSSByView( );
	DSRESULT SetActiveCSSOrigin(double  OriginX, double  OriginY, double  OriginZ);
	DSRESULT AlignActiveCSSZAxis(double  OriginX, double  OriginY, double  OriginZ, double  DirectionX, double  DirectionY, double  DirectionZ);
	DSRESULT SaveAciveViewAs(const dsString&  Name, dsCCS_c ** CCS, dsCreateObjectResult_e* Result);
};
