//========================================================================//
//							SOURCE CODE LICENSE							  //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsByteArray.h, C++ API dsByteArray interface
//
#pragma once

#include "dsLibrary_global.h"

class dsByteArray_pimpl;
class DSLIBRARY_EXPORT dsByteArray
{
public:
    dsByteArray(); // constructor 
    dsByteArray(const dsByteArray &a); // copy constructor 
    ~dsByteArray(); // distructor 
    dsByteArray& operator = (const dsByteArray &a); // assignment operator 
 
    unsigned char& operator [] (unsigned int index) const; // get array item 
    void add(const unsigned char &item); // Add item to the end of array 
 
    unsigned int getSize() const; // get size of array (elements)
    void setSize(unsigned int newsize); // set size of array (elements)
    void clear(); // clear array
    bool removeAt(unsigned int pos); // delete array item 
	void* getptr(); // get void* pointer to array data
 
    enum exception { MEMFAIL, WRONG_INDEX  }; // exception enum 
 
private:
    dsByteArray_pimpl *m_pimpl;    
};
