//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsBlockInstance_c.h, C++ API dsBlockInstance_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"

class dsTransparency_c;
class dsBlockDefinition_c;
class dsBlockInstance_p;
class dsBlockInstance;
class dsColor_c;
class dsCustomData_c;
class dsHyperLink_c;
class dsMathVector_c;
class dsDictionary_c;
class DSINTERFACE_EXPORT dsBlockInstance_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsBlockInstance)
public:
	DSRESULT IsSame(dsBlockInstance_c* Obj);

	DSRESULT get_Layer(dsString* Val);
	DSRESULT put_Layer(const dsString& NewVal);
	DSRESULT get_LineStyle(dsString* Val);
	DSRESULT put_LineStyle(const dsString& NewVal);
	DSRESULT get_LineScale(double* Val);
	DSRESULT put_LineScale(double NewVal);
	DSRESULT get_LineWeight(dsLineWeight_e* Val);
	DSRESULT put_LineWeight(dsLineWeight_e NewVal);	
	DSRESULT get_Visible(bool* Val);
	DSRESULT put_Visible(bool NewVal);
	DSRESULT Select(bool SelectFlag, bool* Res);
	DSRESULT GetID(long* BlockID);
	DSRESULT GetBlockDefinition(dsBlockDefinition_c** BlockDef);
	DSRESULT GetAttributeInstances(dsObjectPtrArray* AttributeInstanceArray);
	DSRESULT GetWorkingSpace(dsObjectType_e* Type, dsObject **WorkSpace);
	DSRESULT GetPosition(double* X, double* Y, double* Z);
	DSRESULT SetPosition(double X, double Y, double Z);
	DSRESULT GetScales(double* ScaleX, double* ScaleY, double* ScaleZ);
	DSRESULT SetScales(double ScaleX, double ScaleY, double ScaleZ);
	DSRESULT get_Rotation(double* Val);
	DSRESULT put_Rotation(double NewVal);
	DSRESULT get_Color(dsColor_c ** Val);
	DSRESULT put_Color(dsColor_c * NewVal);
	DSRESULT get_Erased(bool * Val);
	DSRESULT put_Erased(bool  NewVal);
	DSRESULT GetCustomData(const dsString&  ApplicationName, dsCustomData_c ** CustomData);
	DSRESULT SetCustomData(const dsString&  ApplicationName, dsCustomData_c * CustomData);
	DSRESULT DeleteCustomData(const dsString&  ApplicationName);
	DSRESULT get_Handle(dsString*  Val);
	DSRESULT Explode( );
	DSRESULT GetHyperLink(dsHyperLink_c ** HyperLink);
	DSRESULT SetHyperLink(dsHyperLink_c * HyperLink);
	DSRESULT DeleteHyperLink( );
	DSRESULT GetBoundingBox(double * X1, double * Y1, double * Z1, double * X2, double * Y2, double * Z2);
	DSRESULT GetNormal(dsMathVector_c ** Normal);
	DSRESULT SetNormal(dsMathVector_c * Normal);
	DSRESULT CreateExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT GetExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT ReleaseExtensionDictionary(bool * Result);
	DSRESULT get_PrintStyle(dsString*  Val);
	DSRESULT put_PrintStyle(const dsString&  NewVal);
	DSRESULT get_Transparency(dsTransparency_c ** Val);
	DSRESULT put_Transparency(dsTransparency_c * NewVal);
};
