//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsBlockDefinition_c.h, C++ API dsBlockDefinition_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"
#include "dsLongArray.h"

class dsBlockInstance_c;
class dsExternalReference_c;
class dsBlockDefinition_p;
class dsBlockDefinition;
class dsCustomData_c;
class dsDictionary_c;
class dsHyperLink_c;
class DSINTERFACE_EXPORT dsBlockDefinition_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsBlockDefinition)
public:
	DSRESULT IsSame(dsBlockDefinition_c* Obj);
	DSRESULT GetBlockInstances(dsObjectPtrArray* BlockInstanceArray);
	DSRESULT GetAttributeDefinitions(dsObjectPtrArray* AttributeDefinitionArray);
	DSRESULT GetExternalReference(dsExternalReference_c** ExtRef);
	DSRESULT GetName(dsString* Name);
	DSRESULT GetCustomData(const dsString&  ApplicationName, dsCustomData_c ** CustomData);
	DSRESULT SetCustomData(const dsString&  ApplicationName, dsCustomData_c * CustomData);
	DSRESULT DeleteCustomData(const dsString&  ApplicationName);
	DSRESULT get_Handle(dsString*  Val);
	DSRESULT GetBoundingBox(double * X1, double * Y1, double * Z1, double * X2, double * Y2, double * Z2);
	DSRESULT get_Explodable(bool * Val);
	DSRESULT put_Explodable(bool  NewVal);
	DSRESULT get_ApplyUniformScale(bool * Val);
	DSRESULT put_ApplyUniformScale(bool  NewVal);
	DSRESULT get_BlockInsertUnits(dsBlockInsertUnits_e* Val);
	DSRESULT put_BlockInsertUnits(dsBlockInsertUnits_e NewVal);
	DSRESULT GetEntities(dsLongArray* EntityTypeLongArray, dsObjectPtrArray * EntitiesArray);
	DSRESULT GetBasePoint(double * X, double * Y, double * Z);
	DSRESULT SetBasePoint(double  X, double  Y, double  Z);
	DSRESULT AddTemporaryEntity(dsObject * Entity );
	DSRESULT CreateExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT GetExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT ReleaseExtensionDictionary(bool * Result);
	DSRESULT SetHyperLink(dsHyperLink_c*  HyperLink);
	DSRESULT GetHyperLink(dsHyperLink_c**  HyperLink);
	DSRESULT DeleteHyperLink( );
	DSRESULT Rename(const dsString&  BlockName, dsCreateObjectResult_e*  Result);
};
