//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsArcLengthDimension_c.h, C++ API dsArcLengthDimension_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"

class dsArcLengthDimension_p;
class dsArcLengthDimension;
class dsGeneralDimension_c;
class DSINTERFACE_EXPORT dsArcLengthDimension_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsArcLengthDimension)
public:
	DSRESULT IsSame(dsArcLengthDimension_c* dsObj);

	DSRESULT GetGeneralDimension(dsGeneralDimension_c ** GeneralDimension);
	DSRESULT GetArcPoint(double * X, double * Y, double * Z);
	DSRESULT SetArcPoint(double  X, double  Y, double  Z);
	DSRESULT GetExtensionLine1Point(double * X, double * Y, double * Z);
	DSRESULT SetExtensionLine1Point(double  X, double  Y, double  Z);
	DSRESULT GetExtensionLine2Point(double * X, double * Y, double * Z);
	DSRESULT SetExtensionLine2Point(double  X, double  Y, double  Z);
	DSRESULT GetCenterPoint(double * X, double * Y, double * Z);
	DSRESULT SetCenterPoint(double  X, double  Y, double  Z);
	DSRESULT get_HasLeader(bool * Val);
	DSRESULT put_HasLeader(bool  NewVal);
	DSRESULT get_ArcSymbolType(dsArcSymbolType_e* Val);
	DSRESULT put_ArcSymbolType(dsArcSymbolType_e NewVal);
	DSRESULT get_IsPartial(bool * Val);
	DSRESULT put_IsPartial(bool  NewVal);
};
