//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsAngularDimension_c.h, C++ API dsAngularDimension_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"

class dsAngularDimension_p;
class dsAngularDimension;
class dsGeneralDimension_c;
class DSINTERFACE_EXPORT dsAngularDimension_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsAngularDimension)
public:
	DSRESULT IsSame(dsAngularDimension_c* dsObj);

	DSRESULT GetGeneralDimension(dsGeneralDimension_c ** GeneralDimension);
	DSRESULT get_Type(dsAngularDimensionType_e* Val);
	DSRESULT GetArcPoint(double * X, double * Y, double * Z);
	DSRESULT SetArcPoint(double  X, double  Y, double  Z);
	DSRESULT GetLine1Point(double * X, double * Y, double * Z);
	DSRESULT SetLine1Point(double  X, double  Y, double  Z);
	DSRESULT GetLine2Point(double * X, double * Y, double * Z);
	DSRESULT SetLine2Point(double  X, double  Y, double  Z);
	DSRESULT GetLine1EndPoint(double * X, double * Y, double * Z);
	DSRESULT SetLine1EndPoint(double  X, double  Y, double  Z);
	DSRESULT GetLine2EndPoint(double * X, double * Y, double * Z);
	DSRESULT SetLine2EndPoint(double  X, double  Y, double  Z);
	DSRESULT GetCenterPoint(double * X, double * Y, double * Z);
	DSRESULT SetCenterPoint(double  X, double  Y, double  Z);
};
