//========================================================================//
//                        SOURCE CODE LICENSE                             //
//  Copyright 2017 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsMathVector.js, JavaScript API dsMathVector interface
//

djObjectExtendCollection.dsMathVector = djMathVectorExtend;

function djMathVectorExtend(dsObj) {
	dsObj.release =  function() { return djProcessCommand(this, 'release', arguments); };
	dsObj.GetCoordinates = function() {return djProcessCommand(this, 'GetCoordinates', arguments); };
	dsObj.SetCoordinates = function(X, Y, Z) {return djProcessCommand(this, 'SetCoordinates', arguments); };
	dsObj.Add = function(Vector) {return djProcessCommand(this, 'Add', arguments); };
	dsObj.Subtract = function(Vector) {return djProcessCommand(this, 'Subtract', arguments); };
	dsObj.ScaleVector = function(ScaleFactor) {return djProcessCommand(this, 'ScaleVector', arguments); };
	dsObj.CrossProduct = function(Vector) {return djProcessCommand(this, 'CrossProduct', arguments); };
	dsObj.DotProduct = function(Vector) {return djProcessCommand(this, 'DotProduct', arguments); };
	dsObj.GetLength = function() {return djProcessCommand(this, 'GetLength', arguments); };
	dsObj.Normalise = function() {return djProcessCommand(this, 'Normalise', arguments); };
	dsObj.TransformBy = function(Transform) {return djProcessCommand(this, 'TransformBy', arguments); };
	dsObj.AngleOnPlane = function(Plane) {return djProcessCommand(this, 'AngleOnPlane', arguments); };
	dsObj.AngleTo = function(Vector) {return djProcessCommand(this, 'AngleTo', arguments); };
	dsObj.IsCodirectionalTo = function(Vector, Tolerance) {return djProcessCommand(this, 'IsCodirectionalTo', arguments); };
	dsObj.IsParallelTo = function(Vector, Tolerance) {return djProcessCommand(this, 'IsParallelTo', arguments); };
	dsObj.IsPerpendicularTo = function(Vector, Tolerance) {return djProcessCommand(this, 'IsPerpendicularTo', arguments); };
	dsObj.Negate = function() {return djProcessCommand(this, 'Negate', arguments); };
	dsObj.ConvertToPoint = function() {return djProcessCommand(this, 'ConvertToPoint', arguments); };
	//Add forward methods above this line
}
