//========================================================================//
//                        SOURCE CODE LICENSE                             //
//  Copyright 2017 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsMathUtility.js, JavaScript API dsMathUtility interface
//

djObjectExtendCollection.dsMathUtility = djMathUtilityExtend;

function djMathUtilityExtend(dsObj) {
	dsObj.release =  function() { return djProcessCommand(this, 'release', arguments); };
	dsObj.CreateTransform = function(DataDblArray) {return djProcessCommand(this, 'CreateTransform', arguments); };
	dsObj.CreateTransformRotation = function(CenterPoint, Axis, Angle) {return djProcessCommand(this, 'CreateTransformRotation', arguments); };
	dsObj.CreateTransformMirroringAboutPoint = function(MirrorPoint) {return djProcessCommand(this, 'CreateTransformMirroringAboutPoint', arguments); };
	dsObj.CreateTransformMirroringAboutLine = function(MirrorLine) {return djProcessCommand(this, 'CreateTransformMirroringAboutLine', arguments); };
	dsObj.CreateTransformMirroringAboutPlane = function(MirrorPlane) {return djProcessCommand(this, 'CreateTransformMirroringAboutPlane', arguments); };
	dsObj.CreateTransformProjection = function(ProjectionPlane, ProjectionDirection) {return djProcessCommand(this, 'CreateTransformProjection', arguments); };
	dsObj.CreateTransformScaling = function(CenterPoint, Scale) {return djProcessCommand(this, 'CreateTransformScaling', arguments); };
	dsObj.CreateTransformTranslation = function(TranslationVector) {return djProcessCommand(this, 'CreateTransformTranslation', arguments); };
	dsObj.CreatePoint = function(X, Y, Z) {return djProcessCommand(this, 'CreatePoint', arguments); };
	dsObj.CreateLine = function(StartX, StartY, StartZ, EndX, EndY, EndZ, Type) {return djProcessCommand(this, 'CreateLine', arguments); };
	dsObj.CreateVector = function(X, Y, Z) {return djProcessCommand(this, 'CreateVector', arguments); };
	dsObj.CreateXYPlane = function() {return djProcessCommand(this, 'CreateXYPlane', arguments); };
	dsObj.CreateYZPlane = function() {return djProcessCommand(this, 'CreateYZPlane', arguments); };
	dsObj.CreateZXPlane = function() {return djProcessCommand(this, 'CreateZXPlane', arguments); };
	dsObj.CreatePlaneByNormal = function(Origin, Normal) {return djProcessCommand(this, 'CreatePlaneByNormal', arguments); };
	dsObj.CreatePlaneByUV = function(Origin, UAxis, VAxis) {return djProcessCommand(this, 'CreatePlaneByUV', arguments); };
	dsObj.Distance = function(Object1, Object2) {return djProcessCommand(this, 'Distance', arguments); };
	dsObj.CreateLineByPointAndDirection = function(StartX, StartY, StartZ, Direction, Type) {return djProcessCommand(this, 'CreateLineByPointAndDirection', arguments); };
	dsObj.CreateCircle = function(Center, Normal, Radius) {return djProcessCommand(this, 'CreateCircle', arguments); };
	dsObj.CreateCircArc = function(Center, Normal, RefVector, Radius, StartAngle, EndEngle) {return djProcessCommand(this, 'CreateCircArc', arguments); };
	dsObj.CreateCircArcBy3Points = function(StartPoint, ThroughPoint, EndPoint) {return djProcessCommand(this, 'CreateCircArcBy3Points', arguments); };
	dsObj.CreateEllipse = function(Center, MajorAxis, MinorAxis, MajorRadius, MinorRadius) {return djProcessCommand(this, 'CreateEllipse', arguments); };
	dsObj.CreateEllipArc = function(Center, MajorAxis, MinorAxis, MajorRadius, MinorRadius, StartAngle, EndAngle) {return djProcessCommand(this, 'CreateEllipArc', arguments); };
	dsObj.CreateCircleBy3Points = function(FirstPoint, SecondPoint, ThirdPoint) {return djProcessCommand(this, 'CreateCircleBy3Points', arguments); };
	//Add forward methods above this line
}
