#include "stdafx.h"
#include "Options.h"
#include "dsAddinConnection.h"

TrackerDemoApplication *globalTrackerDemo = 0;
const dsString TrackerDemoApplication::appID = L"1C85DA6C-0445-4844-A66F-A048A5787A68";

void TrackerDemoApplication::CreateUserInterfaceAndCommands()
{
    // 1 - First register your command here
    //     (for invoking the command from the command line)
    m_CommandTrackerDemo.createAndRegisterCommand();

    // Menu should be between "Modify" and "Tools" menus
    const int USERMENU_POSITION = 9;

    // Create user menu
    dsMenuItem_ptr menu;
    application->AddMenu(
        TrackerDemoApplication::appID,
        dsUIState_Document,
        USERMENU_POSITION,
        L"TrackerDemo",
        &menu);
    if (!menu)
        return;
    long menu_position = 1;

    // Create toolbar
    dsToolbar_ptr toolbar;
    application->AddToolbar(
        TrackerDemoApplication::appID,
        dsUIState_Document,
        L"TrackerDemo",
        &toolbar);
    if (!toolbar)
        return;
    long toolbar_position = 1;

    // 2 - Then append your command here, where you see fit in the menus.
    //     You can also create a new menu.

    m_CommandTrackerDemo.createUserCommand();
    m_CommandTrackerDemo.insert(menu, menu_position++);
    m_CommandTrackerDemo.insert(toolbar, toolbar_position++);
}

#ifdef DS_WIN
TrackerDemo_EXPORT bool connectToDraftSight(int cookie, dsApplication_c *dsApp)
#else //DS_WIN
extern "C" TrackerDemo_EXPORT bool connectToDraftSight(int cookie, dsApplication_c *dsApp)
#endif //DS_WIN
{
    if (!globalTrackerDemo)
    {
        Options::instance().application = dsApp;
        Options::instance().ApiUuid = TrackerDemoApplication::appID;
        globalTrackerDemo = new TrackerDemoApplication(dsApp);
        globalTrackerDemo->CreateUserInterfaceAndCommands();
    }
    return globalTrackerDemo;
}

#ifdef DS_WIN
TrackerDemo_EXPORT bool disconnectFromDraftSight()
#else //DS_WIN
extern "C" TrackerDemo_EXPORT bool disconnectFromDraftSight()
#endif //DS_WIN
{
    if (globalTrackerDemo)
    {
        Options::instance().application->RemoveUserInterface(
            TrackerDemoApplication::appID);
        delete globalTrackerDemo;
        globalTrackerDemo = 0;
    }
    return true;
}


#ifdef DS_WIN
TrackerDemo_EXPORT bool HasSignedByDraftSight(dsString *sId1, int *iId2, int *iKey1, int *iKey2)
#else //DS_WIN
extern "C" TrackerDemo_EXPORT bool HasSignedByDraftSight(dsString *sId1, int *iId2, int *iKey1, int *iKey2)
#endif //DS_WIN
{
    *sId1 = dsString( L"A085E761-D046-4f6b-BFA2-02F0DDD1B10E" );
    return true;
}
