#ifndef COMMANDTRACKERDEMO_H
#define COMMANDTRACKERDEMO_H

#include "dsTracker_c.h"
#include "dsMathPoint_c.h"
#include "dsPolyLine_c.h"

#include "../miscellaneous.h"
#include "../Options.h"
#include "../CommandBase.h"

class CommandTrackerDemo : public CommandBase
{
public:
    CommandTrackerDemo();
    ~CommandTrackerDemo();

    const dsString groupName() const { return Options::instance().ApiUuid; }
    const dsString globalName() const { return L"_TRACKERDEMO"; }
    const dsString localName() const { return L"TRACKERDEMO"; }
    const dsString Description() const { return
        L"Demonstrates trackers for insertion, scale, and angle"; }
    const dsString ItemName() const { return L"Tracker demo"; }

    bool ExecuteNotify();

    // This event is triggered, when one of the trackers changes:
    //     * m_InsertionTracker
    //     * m_ScaleTracker
    //     * m_RotationTracker
    bool UpdateNotify(dsMathPoint_c *CursorPosition);
    DeclareTrackerUpdateNotifyHook

private:
    dsTracker_ptr m_InsertionTracker;
    dsTracker_ptr m_ScaleTracker;
    dsTracker_ptr m_RotationTracker;

    // 1 - Tracker for insertion
    // 2 - Tracker for scale
    // 3 - Tracker for rotation
    int m_TrackerType;

    // Rubberband (temporary object)
    dsPolyLine_ptr m_PolyLine;

    // Used for transforming m_PolyLine
    dsMathPoint_ptr m_pt1;
    dsMathPoint_ptr m_pt2;
    dsMathPoint_ptr m_pt3;
    dsMathPoint_ptr m_pt4;
};

#endif // COMMANDTRACKERDEMO_H
