#include "dsCommandMessage_c.h"
#include "CommandTrackerDemo.h"

CommandTrackerDemo::CommandTrackerDemo()
    : CommandBase(Options::instance().application)
{
    application->CreateTracker(&m_InsertionTracker);
    application->CreateTracker(&m_ScaleTracker);
    application->CreateTracker(&m_RotationTracker);

    RegisterTrackerUpdateNotifyHook(m_InsertionTracker);
    RegisterTrackerUpdateNotifyHook(m_ScaleTracker);
    RegisterTrackerUpdateNotifyHook(m_RotationTracker);
}

CommandTrackerDemo::~CommandTrackerDemo()
{
    if (m_command)
    {
        UnRegisterTrackerUpdateNotifyHook(m_InsertionTracker);
        UnRegisterTrackerUpdateNotifyHook(m_ScaleTracker);
        UnRegisterTrackerUpdateNotifyHook(m_RotationTracker);
    }
}

bool CommandTrackerDemo::ExecuteNotify()
{
    // Get the command line interface.
    dsCommandMessage_ptr commandline;
    application->GetCommandMessage(&commandline);
    dsDocument_ptr doc;
    application->GetActiveDocument(&doc);
    dsModel_ptr model;
    doc->GetModel(&model);
    dsSketchManager_ptr sketchmanager;
    model->GetSketchManager(&sketchmanager);

    // Turn On TemporaryEntityMode
    application->put_TemporaryEntityMode(true);

	dsDoubleArray coordArray;
	coordArray.add(0.0); coordArray.add(0.0);
	coordArray.add(10.0); coordArray.add(0.0);
	coordArray.add(10.0); coordArray.add(10.0);
	coordArray.add(0.0); coordArray.add(10.0);

    sketchmanager->InsertPolyline2D( coordArray, true, &m_PolyLine );

    // Turn Off TemporaryEntityMode
    application->put_TemporaryEntityMode(false); 

    double pickX = 0, pickY = 0, pickZ = 0;
    bool result;

    dsMathUtility_ptr math;
    application->GetMathUtility(&math);
    dsMathPlane_ptr plane;
    math->CreateXYPlane(&plane);

    m_TrackerType = 1; // Tracker for Insertion point
    m_InsertionTracker->AddTemporaryEntity(m_PolyLine);
    commandline->AddTracker(m_InsertionTracker);	
    commandline->PromptForPoint2(
        L"Specify insertion point",
        false,
        0, 0, 0,
        &pickX, &pickY, &pickZ,
        plane,
        &result);
    m_InsertionTracker->RemoveTemporaryEntity(m_PolyLine);
    commandline->RemoveTracker(m_InsertionTracker);

    if (!result)
        return false;

    bool Success;
    m_PolyLine->SetVertexCoordinate(0, pickX, pickY, &Success);
    m_PolyLine->SetVertexCoordinate(1, pickX + 10, pickY, &Success);
    m_PolyLine->SetVertexCoordinate(2, pickX + 10, pickY + 10, &Success);
    m_PolyLine->SetVertexCoordinate(3, pickX, pickY + 10, &Success);

    m_TrackerType = 2; // Tracker for Scale rectangle
    m_ScaleTracker->AddTemporaryEntity(m_PolyLine);
    commandline->AddTracker(m_ScaleTracker);
    commandline->PromptForPoint2(
        L"Specify opposite corner",
        false,
        0, 0, 0,
        &pickX, &pickY, &pickZ,
        plane,
        &result);
    m_ScaleTracker->RemoveTemporaryEntity(m_PolyLine);
    commandline->RemoveTracker(m_ScaleTracker);

    if (!result)
        return false;

    double x = 0.0, y = 0.0;
    m_PolyLine->GetVertexCoordinate(0, &x, &y,&Success);

    double distX = pickX - x;
    double distY = pickY - y;
    m_PolyLine->SetVertexCoordinate(1, x + distX, y, &Success);
    m_PolyLine->SetVertexCoordinate(2, x + distX, y + distY, &Success);
    m_PolyLine->SetVertexCoordinate(3, x, y + distY, &Success);

    math->CreatePoint(x, y, 0.0, &m_pt1);
    math->CreatePoint(x + distX, y, 0.0, &m_pt2);
    math->CreatePoint(x + distX, y + distY, 0.0, &m_pt3);
    math->CreatePoint(x, y + distY, 0.0, &m_pt4);

    m_TrackerType = 3; // Tracker for Rotate rectangle
    m_RotationTracker->AddTemporaryEntity(m_PolyLine);
    commandline->AddTracker(m_RotationTracker);
    commandline->PromptForPoint2(
        L"Specify rotation (point)",
        false,
        0, 0, 0,
        &pickX, &pickY, &pickZ,
        plane,
        &result);
    m_RotationTracker->RemoveTemporaryEntity(m_PolyLine);
    commandline->RemoveTracker(m_RotationTracker);

    if (!result)
        return false;

    double z = 0.0;
    m_pt1->GetPosition(&x, &y, &z);

    //get rotation angle
    double rotationAngle = arctan(x, y, pickX, pickY);

    double pointToModify[] =  { 0, 0, 0 };
    double pointResult[] =  { 0, 0, 0 };

    //create rotation matrix
    dsMathVector_ptr dsZAxis;
    math->CreateVector(0.0, 0.0, 1.0,&dsZAxis);

    dsMathTransform_ptr dsMathTransform;
    math->CreateTransformRotation(m_pt1, dsZAxis, rotationAngle, &dsMathTransform);

    //transform second polyline point
    m_pt2->GetPosition(&pointToModify[0], &pointToModify[1], &pointToModify[2]);
    dsMathPoint_ptr pLinePoint;
    math->CreatePoint(pointToModify[0], pointToModify[1], pointToModify[2], &pLinePoint);
    pLinePoint->TransformBy(dsMathTransform);
    pLinePoint->GetPosition(&pointResult[0], &pointResult[1], &pointResult[2]);
    m_PolyLine->SetVertexCoordinate(1, pointResult[0], pointResult[1], &Success);

    //transform third polyline point
    m_pt3->GetPosition(&pointToModify[0], &pointToModify[1], &pointToModify[2]);
    math->CreatePoint(pointToModify[0], pointToModify[1], pointToModify[2], &pLinePoint);
    pLinePoint->TransformBy(dsMathTransform);
    pLinePoint->GetPosition(&pointResult[0], &pointResult[1], &pointResult[2]);
    m_PolyLine->SetVertexCoordinate(2, pointResult[0], pointResult[1], &Success);

    //transform fourth polyline point
    m_pt4->GetPosition(&pointToModify[0], &pointToModify[1], &pointToModify[2]);
    math->CreatePoint(pointToModify[0], pointToModify[1], pointToModify[2], &pLinePoint);
    pLinePoint->TransformBy(dsMathTransform);
    pLinePoint->GetPosition(&pointResult[0], &pointResult[1], &pointResult[2]);
    m_PolyLine->SetVertexCoordinate(3, pointResult[0], pointResult[1], &Success);

    //add temporary polyline to sketchmanager
    sketchmanager->AddTemporaryEntity(m_PolyLine);

    return true;
}

ImplementTrackerUpdateNotifyHook(CommandTrackerDemo)

bool CommandTrackerDemo::UpdateNotify(dsMathPoint_c *CursorPosition)
{
    double cursorX = 0, cursorY = 0, cursorZ = 0;
    CursorPosition->GetPosition(&cursorX, &cursorY, &cursorZ);
    bool Success;

    switch(m_TrackerType)
    {
    case 1: // Tracker for Insertion
        m_PolyLine->SetVertexCoordinate(0, cursorX, cursorY, &Success);
        m_PolyLine->SetVertexCoordinate(1, cursorX + 10, cursorY, &Success);
        m_PolyLine->SetVertexCoordinate(2, cursorX + 10, cursorY + 10, &Success);
        m_PolyLine->SetVertexCoordinate(3, cursorX, cursorY + 10, &Success);
        break;
    case 2: // Tracker for Scale
        {
            double x = 0.0, y = 0.0;
            m_PolyLine->GetVertexCoordinate(0, &x, &y, &Success);

            double distX = cursorX - x;
            double distY = cursorY - y;
            m_PolyLine->SetVertexCoordinate(1, x + distX, y, &Success);
            m_PolyLine->SetVertexCoordinate(2, x + distX, y + distY, &Success);
            m_PolyLine->SetVertexCoordinate(3, x, y + distY, &Success);
        }
        break;
    case 3: // Tracker for Rotation
        {
            double x = 0.0, y = 0.0, z = 0.0;
            m_pt1->GetPosition(&x, &y, &z);

            dsMathUtility_ptr dsMathUtility;
            application->GetMathUtility(&dsMathUtility);

            //get rotation angle
            double rotationAngle = arctan(x, y, cursorX, cursorY);

            double pointToModify[] =  { 0, 0, 0 };
            double pointResult[] =  { 0, 0, 0 };

            //create rotation matrix
            dsMathVector_ptr dsZAxis;
            dsMathUtility->CreateVector(0.0, 0.0, 1.0,&dsZAxis);

            dsMathTransform_ptr dsMathTransform;
            dsMathUtility->CreateTransformRotation(
                m_pt1, dsZAxis, rotationAngle, &dsMathTransform);

            //transform second polyline point
            m_pt2->GetPosition(&pointToModify[0], &pointToModify[1], &pointToModify[2]);
            dsMathPoint_ptr pLinePoint;
            dsMathUtility->CreatePoint(pointToModify[0], pointToModify[1], pointToModify[2], &pLinePoint);
            pLinePoint->TransformBy(dsMathTransform);
            pLinePoint->GetPosition(&pointResult[0], &pointResult[1], &pointResult[2]);
            m_PolyLine->SetVertexCoordinate(1, pointResult[0], pointResult[1], &Success);

            //transform third polyline point
            m_pt3->GetPosition(&pointToModify[0], &pointToModify[1], &pointToModify[2]);
            dsMathUtility->CreatePoint(pointToModify[0], pointToModify[1], pointToModify[2], &pLinePoint);
            pLinePoint->TransformBy(dsMathTransform);
            pLinePoint->GetPosition(&pointResult[0], &pointResult[1], &pointResult[2]);
            m_PolyLine->SetVertexCoordinate(2, pointResult[0], pointResult[1], &Success);

            //transform fourth polyline point
            m_pt4->GetPosition(&pointToModify[0], &pointToModify[1], &pointToModify[2]);
            dsMathUtility->CreatePoint(pointToModify[0], pointToModify[1], pointToModify[2], &pLinePoint);
            pLinePoint->TransformBy(dsMathTransform);
            pLinePoint->GetPosition(&pointResult[0], &pointResult[1], &pointResult[2]);
            m_PolyLine->SetVertexCoordinate(3, pointResult[0], pointResult[1], &Success);
        }
        break;
    default:break;
    }

    return true;
}
