#ifndef DS_ADDIN_CONNECTION_H
#define DS_ADDIN_CONNECTION_H

/*
Sample Name: Selection

Sample Description:
    This sample shows how to work with dsAPI's selection manager.

Usage:
    _SHOWTYPES "Show selected types"
        This command will simply display the types of the selected objects.

    _CONNECTTWOLINES "Connect two lines"
        This command prompts the user to select two lines and creates then
        another line joining the two selected lines.

Overview:
    Functionality:
        We want to draw your attention to the bodies of the two commands:
            * CommandShowTypes::ExecuteNotify()
            * CommandConnectTwoLines::ExecuteNotify()
        There you can see how the selection manager is used and how you can
        access selected objects.

    Command classes:
        Both commands derive from CommandBase. This base class provides an
        interface for both, registering a command to be used from the
        command line via CommandBase::registerCommand() as well as putting
        a command into a menu item via CommandBase::createUserCommand(), so
        done in SelectionApplication::CreateUserInterfaceAndCommands().

    Globally available options:
        This singleton Options class holds a globally accessible pointer
        to the application as well as the UUID of this add-in. You can add
        any data that is ought to be available throughout this program.

        Furthermore, there is the miscellaneous.h, a collection of useful
        functions for converting between dsAPI and Qt classes. These
        functions are used throughout the add-in.

Notable dsAPI functions used:
        dsDocument_c::GetSelectionManager()
        dsSelectionManager_c::GetSelectedObjectCount()
        dsSelectionManager_c::GetSelectedObject()
*/

#include "dsApplication_c.h"
#include "dsInterfacePtr.h"
#include "Selection_global.h"

// You can append new commands like this:
// 1 - Append the header file here.
// 2 - Add the command as a private member of SelectionApplication.
// 3 - Go to bool SelectionApplication::CreateUserInterfaceAndCommands() and:
//     1 - Register your command using the registerCommand()
//         (then the command can be invoked from the command line).
//     2 - If it makes sense, add it to the user menu
//         (then the command can be invoked from the user menu as well).
#include "commands/CommandShowTypes.h"
#include "commands/CommandConnectTwoLines.h"

class Selection_EXPORT SelectionApplication{
public:
    SelectionApplication(dsApplication_c *dsApp) : application(dsApp) {}

    void CreateUserInterfaceAndCommands();
    static const dsString appID;

private:
    dsApplication_ptr application;
    CommandShowTypes m_CommandShowTypes;
    CommandConnectTwoLines m_CommandConnectTwoLines;
};

#endif // DS_ADDIN_CONNECTION_H
