#include "dsCommandMessage_c.h"
#include "dsLine_c.h"
#include "CommandConnectTwoLines.h"

bool CommandConnectTwoLines::ExecuteNotify()
{
    // Get DraftSight command line interface
    dsCommandMessage_ptr commandline;
    application->GetCommandMessage(&commandline);
    bool result;
    if (commandline->PromptForSelection(
        true,
        L"Select first Line",
        L"",
        &result) != DSRESULT_True || !result)
    {
        return false;
    }

    // Get selection manager
    dsDocument_ptr document;
    application->GetActiveDocument(&document);
    dsSelectionManager_ptr selectionmanager;
    document->GetSelectionManager(&selectionmanager);
    dsObjectType_e type;
    dsObject *o;
    selectionmanager->GetSelectedObject(dsSelectionSetType_Previous, 0, &type, &o);
    if (type != dsLineType)
        return false;

    double X1, Y1, Z1;
    double X2, Y2, Z2;
    dsLine_c *line = (dsLine_c*)o;
    line->GetFirstPoint(&X1, &Y1, &Z1);
    line->GetSecondPoint(&X2, &Y2, &Z2);

    dsDoubleArray firstPointArr;
    selectionmanager->GetPickPoints(dsSelectionSetType_Previous, &firstPointArr);

    dsMathPoint_ptr dsFirstPoint;
    dsMathPoint_ptr dsSecondPoint;
    dsMathUtility_ptr math; 
    application->GetMathUtility(&math);

    dsMathPoint_ptr point1, point2;
    double newFirstPoint[3], newSecondPoint[3];
    double distance1, distance2;
    math->CreatePoint(X1, Y1, Z1, &dsFirstPoint);
    math->CreatePoint(firstPointArr[0], firstPointArr[1], firstPointArr[2], &dsSecondPoint);
    math->Distance(dsFirstPoint, dsSecondPoint, &point1, &point2, &distance1);
    math->CreatePoint(X2, Y2, Z2, &dsFirstPoint);
    math->Distance(dsFirstPoint, dsSecondPoint, &point1, &point2, &distance2);

    if (distance1 > distance2)
    {
        newFirstPoint[0] = X2;
        newFirstPoint[1] = Y2;
        newFirstPoint[2] = Z2;
    }
    else
    {
        newFirstPoint[0] = X1;
        newFirstPoint[1] = Y1;
        newFirstPoint[2] = Z1;
    }

    if (commandline->PromptForSelection(
        true,
        L"Select second Line.",
        L"",
        &result) != DSRESULT_True || !result)
    {
        return false;
    }

    selectionmanager->GetSelectedObject(dsSelectionSetType_Previous, 0, &type, &o);
    if (type != dsLineType)
        return false;
    line = (dsLine_c*)o;
    line->GetFirstPoint(&X1, &Y1, &Z1);
    line->GetSecondPoint(&X2, &Y2, &Z2);

    dsDoubleArray SecondPointArr;
    selectionmanager->GetPickPoints(dsSelectionSetType_Previous, &SecondPointArr);
    math->CreatePoint(X1, Y1, Z1, &dsFirstPoint);
    math->CreatePoint(
        SecondPointArr[0], SecondPointArr[1], SecondPointArr[2],
        &dsSecondPoint);
    math->Distance(dsFirstPoint, dsSecondPoint, &point1, &point2, &distance1);
    math->CreatePoint(X2, Y2, Z2, &dsFirstPoint);
    math->Distance(dsFirstPoint, dsSecondPoint, &point1, &point2, &distance2);

    if (distance1 > distance2)
    {
        newSecondPoint[0] = X2;
        newSecondPoint[1] = Y2;
        newSecondPoint[2] = Z2;
    }
    else
    {
        newSecondPoint[0] = X1;
        newSecondPoint[1] = Y1;
        newSecondPoint[2] = Z1;
    }

    dsModel_ptr model;
    dsSketchManager_ptr sketchmanager; 
    document->GetModel(&model);
    model->GetSketchManager(&sketchmanager);
    sketchmanager->InsertLine(
        newFirstPoint[0], newFirstPoint[1], newFirstPoint[2],
        newSecondPoint[0], newSecondPoint[1], newSecondPoint[2],
        &line);

    return true; 
}
