#include "stdafx.h"
#include "Options.h"
#include "dsAddinConnection.h"

RibbonApplication *globalMenuApplication = 0;
const dsString RibbonApplication::appID = L"1C85DA6C-0445-4844-A66F-A048A5787A68";

void RibbonApplication::CreateUserInterfaceAndCommands()
{
    // 1 - First register your command here
    //     (for invoking the command from the command line)
    m_CommandHello.createAndRegisterCommand();

    dsCreateCommandError_e Error;
    dsUserCommand_ptr tb_standards;
    application->CreateUserCommand( RibbonApplication::appID,
        m_CommandHello.localName(), L"^C^CMHELLO" ,
        L"Shows the Ribbon items: MHELLO",
        L":/ribbon/ToolBar_Large.png",
        L":/ribbon/ToolBar_Small.png",
        dsUIState_Document, &Error, &tb_standards );
    dsString tb_Hello_id;
    tb_standards->GetID( &tb_Hello_id );

    dsWorkspace_ptr dsWorkSpace;
    application->AddWorkspace( L"SampleWorkSpace", &dsWorkSpace );
    dsWorkSpace->Activate();

    dsObjectPtrArray dsObjArr;
    dsWorkSpace->GetRibbonTabs( &dsObjArr );

    //Add a New Tab
    dsRibbonTab_ptr ribbonTab;
    dsWorkSpace->AddRibbonTab( RibbonApplication::appID, dsObjArr.getSize() + 1, L"Circle", L"Circle", &ribbonTab );

    if ( ribbonTab )
    {
        //Add a New Pannel to RibbonSampleTab Tab
        dsRibbonPanel_ptr dsRibbonPanel;
        ribbonTab->InsertRibbonPanel( RibbonApplication::appID, 1, L"Sample", L"Sample", &dsRibbonPanel );
        dsRibbonPanel->put_Name(L"Draw Circle");
        dsRibbonPanel->put_DisplayText(L"Draw Circle");

        //Add a New Row to SamplePannel
        dsRibbonRow_ptr dsRibbonRow;
        dsRibbonPanel->InsertRibbonRow( RibbonApplication::appID, L"CircleRow", &dsRibbonRow );
        //Add a New Button to SampleRow
        dsRibbonCommandButton_ptr dsRibbonCmdBtn1, dsRibbonCmdBtn2;
        dsRibbonRow->InsertRibbonCommandButton( RibbonApplication::appID, dsRibbonButtonStyle_LargeWithText, L"Small Circle", tb_Hello_id, &dsRibbonCmdBtn1 );
        //Add a Separator to SampleRow
        dsRibbonSeparator_ptr dsRibbonSeparator;
        dsRibbonRow->InsertRibbonSeparator( RibbonApplication::appID, dsRibbonSeparatorStyle_Spacer, &dsRibbonSeparator );
        //Add a New Button to SampleRow
        dsRibbonRow->InsertRibbonCommandButton( RibbonApplication::appID, dsRibbonButtonStyle_LargeWithText, L"Big Circle", tb_Hello_id, &dsRibbonCmdBtn2 );

        //dsRibbonPanel->DisplayInTab( L"Manage", 8);
        //ribbonTab->put_Name( L"RibbonSampleTab" );
        //ribbonTab->put_DisplayText( L"RibbonSampleTab" );

        //Add a new panel
        ribbonTab->InsertRibbonPanel( RibbonApplication::appID, 2, L"Draw Arc", L"Draw Arc", &dsRibbonPanel );
        dsRibbonPanel->InsertRibbonRow( RibbonApplication::appID, L"ArcRow", &dsRibbonRow );
        //Add a New Button to SampleRow
        dsRibbonRow->InsertRibbonCommandButton( RibbonApplication::appID, dsRibbonButtonStyle_LargeWithText, L"Small Arc", tb_Hello_id, &dsRibbonCmdBtn1 );
        //Add a Separator to SampleRow
        dsRibbonRow->InsertRibbonSeparator( RibbonApplication::appID, dsRibbonSeparatorStyle_Spacer, &dsRibbonSeparator );
        //Add a New Button to SampleRow
        dsRibbonRow->InsertRibbonCommandButton( RibbonApplication::appID, dsRibbonButtonStyle_LargeWithText, L"Big Arc", tb_Hello_id, &dsRibbonCmdBtn2 );
    }

    dsWorkSpace->AddRibbonTab( RibbonApplication::appID, dsObjArr.getSize() + 2, L"Line", L"Line", &ribbonTab );
    if (ribbonTab)
    {
        //Add a New Pannel to RibbonSampleTab Tab
        dsRibbonPanel_ptr dsRibbonPanel;
        ribbonTab->InsertRibbonPanel( RibbonApplication::appID, 1, L"Sample", L"Sample", &dsRibbonPanel );
        dsRibbonPanel->put_Name(L"Draw Line");
        dsRibbonPanel->put_DisplayText(L"Draw Line");

        //Add a New Row to SamplePannel
        dsRibbonRow_ptr dsRibbonRow;
        dsRibbonPanel->InsertRibbonRow( RibbonApplication::appID, L"LineRow", &dsRibbonRow );
        //Add a New Button to SampleRow
        dsRibbonCommandButton_ptr dsRibbonCmdBtn1, dsRibbonCmdBtn2;
        dsRibbonRow->InsertRibbonCommandButton( RibbonApplication::appID, dsRibbonButtonStyle_LargeWithText, L"Small Line", tb_Hello_id, &dsRibbonCmdBtn1 );
        //Add a Separator to SampleRow
        dsRibbonSeparator_ptr dsRibbonSeparator;
        dsRibbonRow->InsertRibbonSeparator( RibbonApplication::appID, dsRibbonSeparatorStyle_Spacer, &dsRibbonSeparator );
        //Add a New Button to SampleRow
        dsRibbonRow->InsertRibbonCommandButton( RibbonApplication::appID, dsRibbonButtonStyle_LargeWithText, L"Big Line", tb_Hello_id, &dsRibbonCmdBtn2 );

    }

    dsWorkSpace->AddRibbonTab( RibbonApplication::appID, dsObjArr.getSize() + 3, L"PolyLine", L"PolyLine", &ribbonTab );
    if (ribbonTab)
    {
        //Add a New Pannel to RibbonSampleTab Tab
        dsRibbonPanel_ptr dsRibbonPanel;
        ribbonTab->InsertRibbonPanel( RibbonApplication::appID, 1, L"Sample", L"Sample", &dsRibbonPanel );
        dsRibbonPanel->put_Name(L"Draw PolyLine");
        dsRibbonPanel->put_DisplayText(L"Draw PolyLine");

        //Add a New Row to SamplePannel
        dsRibbonRow_ptr dsRibbonRow;
        dsRibbonPanel->InsertRibbonRow( RibbonApplication::appID, L"PolyLineRow", &dsRibbonRow );
        //Add a New Button to SampleRow
        dsRibbonCommandButton_ptr dsRibbonCmdBtn1, dsRibbonCmdBtn2;
        dsRibbonRow->InsertRibbonCommandButton( RibbonApplication::appID, dsRibbonButtonStyle_LargeWithText, L"Small PolyLine", tb_Hello_id, &dsRibbonCmdBtn1 );
        //Add a Separator to SampleRow
        dsRibbonSeparator_ptr dsRibbonSeparator;
        dsRibbonRow->InsertRibbonSeparator( RibbonApplication::appID, dsRibbonSeparatorStyle_Spacer, &dsRibbonSeparator );
        //Add a New Button to SampleRow
        dsRibbonRow->InsertRibbonCommandButton( RibbonApplication::appID, dsRibbonButtonStyle_LargeWithText, L"Big PolyLine", tb_Hello_id, &dsRibbonCmdBtn2 );
    }

    dsWorkSpace->AddRibbonTab( RibbonApplication::appID, dsObjArr.getSize() + 4, L"Xline", L"Xline", &ribbonTab );
    if (ribbonTab)
    {
        //Add a New Pannel to RibbonSampleTab Tab
        dsRibbonPanel_ptr dsRibbonPanel;
        ribbonTab->InsertRibbonPanel( RibbonApplication::appID, 1, L"Sample", L"Sample", &dsRibbonPanel );
        dsRibbonPanel->put_Name(L"Draw Xline");
        dsRibbonPanel->put_DisplayText(L"Draw Xline");

        //Add a New Row to SamplePannel
        dsRibbonRow_ptr dsRibbonRow;
        dsRibbonPanel->InsertRibbonRow( RibbonApplication::appID, L"PolyLineRow", &dsRibbonRow );
        //Add a New Button to SampleRow
        dsRibbonCommandButton_ptr dsRibbonCmdBtn1, dsRibbonCmdBtn2;
        dsRibbonRow->InsertRibbonCommandButton( RibbonApplication::appID, dsRibbonButtonStyle_LargeWithText, L"Ray", tb_Hello_id, &dsRibbonCmdBtn1 );
        //Add a Separator to SampleRow
        dsRibbonSeparator_ptr dsRibbonSeparator;
        dsRibbonRow->InsertRibbonSeparator( RibbonApplication::appID, dsRibbonSeparatorStyle_Spacer, &dsRibbonSeparator );
        //Add a New Button to SampleRow
        dsRibbonRow->InsertRibbonCommandButton( RibbonApplication::appID, dsRibbonButtonStyle_LargeWithText, L"Infinite Line", tb_Hello_id, &dsRibbonCmdBtn2 );
    }

    dsWorkSpace->AddRibbonTab( RibbonApplication::appID, dsObjArr.getSize() + 5, L"Ellipse", L"Ellipse", &ribbonTab );
    if (ribbonTab)
    {
        //Add a New Pannel to RibbonSampleTab Tab
        dsRibbonPanel_ptr dsRibbonPanel;
        ribbonTab->InsertRibbonPanel( RibbonApplication::appID, 1, L"Sample", L"Sample", &dsRibbonPanel );
        dsRibbonPanel->put_Name(L"Draw Ellipse");
        dsRibbonPanel->put_DisplayText(L"Draw Ellipse");

        //Add a New Row to SamplePannel
        dsRibbonRow_ptr dsRibbonRow;
        dsRibbonPanel->InsertRibbonRow( RibbonApplication::appID, L"EllipseRow", &dsRibbonRow );
        //Add a New Button to SampleRow
        dsRibbonCommandButton_ptr dsRibbonCmdBtn1, dsRibbonCmdBtn2;
        dsRibbonRow->InsertRibbonCommandButton( RibbonApplication::appID, dsRibbonButtonStyle_LargeWithText, L"Ellipse", tb_Hello_id, &dsRibbonCmdBtn1 );
        //Add a Separator to SampleRow
        dsRibbonSeparator_ptr dsRibbonSeparator;
        dsRibbonRow->InsertRibbonSeparator( RibbonApplication::appID, dsRibbonSeparatorStyle_Spacer, &dsRibbonSeparator );

        dsRibbonSplitButton_ptr dsRibbonSplitButton;
        dsRibbonRow->InsertRibbonSplitButton( RibbonApplication::appID, dsRibbonItemType_SplitButton, dsRibbonButtonStyle_LargeWithText, 
            dsRibbonSplitButtonListStyle_IconText, dsRibbonSplitButtonBehaviour_DropDownFollow, L"Split", &dsRibbonSplitButton );
        //Add a New Button to SampleRow
        dsRibbonSplitButton->InsertRibbonCommandButton( RibbonApplication::appID, dsRibbonButtonStyle_LargeWithText, L"Small Elliptical Arc", tb_Hello_id, &dsRibbonCmdBtn2 );
        dsRibbonSplitButton->InsertRibbonCommandButton( RibbonApplication::appID, dsRibbonButtonStyle_LargeWithText, L"Big Elliptical Arc", tb_Hello_id, &dsRibbonCmdBtn2 );
    }


    //Get system ribbon menu of the workspace
    dsRibbonSystemMenu_c * dsRibbonSystemMenu;
    dsWorkSpace->GetRibbonSystemMenu( &dsRibbonSystemMenu );

    //Get items of the system ribbon menu
    dsObjectPtrArray dsObjMenuArr;
    dsRibbonSystemMenu->GetRibbonSystemMenuItems( &dsObjMenuArr );
    int szRbSysMenu = dsObjMenuArr.getSize();

    //Insert items to the system ribbon menu
    dsRibbonSystemMenuItem_c * dsRibbonSystemMenuItem;
    dsRibbonSystemMenu->InsertRibbonSystemMenuItem( RibbonApplication::appID, 
        dsRibbonItemType_SystemMenuItem, szRbSysMenu+1, L"Circle", tb_Hello_id, &dsRibbonSystemMenuItem );
    dsRibbonSystemMenu->InsertRibbonSystemMenuItem( RibbonApplication::appID, 
        dsRibbonItemType_SystemMenuItem, szRbSysMenu+2, L"Line", tb_Hello_id, &dsRibbonSystemMenuItem );
    dsRibbonSystemMenu->InsertRibbonSystemMenuItem( RibbonApplication::appID, 
        dsRibbonItemType_SystemMenuItem, szRbSysMenu+3, L"PolyLine", tb_Hello_id, &dsRibbonSystemMenuItem );
    dsRibbonSystemMenu->InsertRibbonSystemMenuItem( RibbonApplication::appID, 
        dsRibbonItemType_SystemMenuItem, szRbSysMenu+4, L"Xline", tb_Hello_id, &dsRibbonSystemMenuItem );
    dsRibbonSystemMenu->InsertRibbonSystemMenuItem( RibbonApplication::appID, 
        dsRibbonItemType_SystemMenuItem, szRbSysMenu+5, L"Ellipse", tb_Hello_id, &dsRibbonSystemMenuItem );


    //Add Ribbon Quick Access Bar
    dsRibbonQuickAccessBar_c * dsRibbonQuickAccessBar;
    dsWorkSpace->AddRibbonQuickAccessBar( RibbonApplication::appID, L"SampleRQAB", &dsRibbonQuickAccessBar );

    //Add Ribbon Quick Access Bar items
    dsObjectPtrArray dsObjQABArr;
    dsRibbonQuickAccessBar->GetRibbonQuickAccessBarItems(&dsObjQABArr);
    dsRibbonQuickAccessBarItem_ptr dsRibbonQuickAccessBarItem1;
    dsRibbonQuickAccessBar->InsertRibbonQuickAccessBarItem( RibbonApplication::appID,  L"RQAB", tb_Hello_id, &dsRibbonQuickAccessBarItem1 );
    dsRibbonQuickAccessBarItem_ptr dsRibbonQuickAccessBarItem2;
    dsRibbonQuickAccessBar->InsertRibbonQuickAccessBarItem( RibbonApplication::appID,  L"RQAB", tb_Hello_id, &dsRibbonQuickAccessBarItem2 );
    dsRibbonQuickAccessBar->InsertRibbonQuickAccessBarItem( RibbonApplication::appID,  L"RQAB", tb_Hello_id, &dsRibbonQuickAccessBarItem2 );
    dsRibbonQuickAccessBar->InsertRibbonQuickAccessBarItem( RibbonApplication::appID,  L"RQAB", tb_Hello_id, &dsRibbonQuickAccessBarItem2 );
    dsRibbonQuickAccessBar->InsertRibbonQuickAccessBarItem( RibbonApplication::appID,  L"RQAB", tb_Hello_id, &dsRibbonQuickAccessBarItem2 );
    dsRibbonQuickAccessBarItem2->put_Enabled( false );


    application->GetWorkspace( L"Drafting and Annotation", &dsWorkSpace );
    dsWorkSpace->GetRibbonTabs( &dsObjArr );
    for( int i = 0; i < dsObjArr.getSize(); ++i )
    {
        dsRibbonTab_ptr ribbonTab( (dsRibbonTab_c*)dsObjArr[i] );
        if ( ribbonTab )
        {
            dsString TabName;
            ribbonTab->get_Name( &TabName );
            dsRibbonItemType_e ItemType;
            ribbonTab->GetType( &ItemType );
            if ( ItemType == dsRibbonItemType_Tab && TabName.Compare( L"Manage") == 0 )
            {
                //Add a New Pannel to Add-Ins Tab
                dsObjectPtrArray dsRibbonPanelsArr;
                ribbonTab->GetRibbonPanels(&dsRibbonPanelsArr);
                for( int i = 0; i < dsRibbonPanelsArr.getSize(); ++i )
                {
                    dsRibbonPanel_ptr dsRibbonPanel( (dsRibbonPanel_c*)dsRibbonPanelsArr[i] );
                    if ( dsRibbonPanel )
                    {
                        dsString panelName;
                        dsRibbonPanel->get_Name(&panelName);
                        dsRibbonPanel->GetApiID(&panelName);
                        if( panelName.Compare(L"ID_PanelMacro") == 0 )
                        {
                            dsRibbonRow_ptr dsRibbonRow;
                            dsRibbonPanel->GetRibbonRow( &dsRibbonRow );

                            //Add a Separator to SampleRow
                            dsRibbonSeparator_ptr dsRibbonSeparator;
                            dsRibbonRow->InsertRibbonSeparator( RibbonApplication::appID, dsRibbonSeparatorStyle_Spacer, &dsRibbonSeparator );

                            //Add a New Button to SampleRow
                            dsRibbonCommandButton_ptr dsRibbonCmdBtn1;
                            dsRibbonRow->InsertRibbonCommandButton( RibbonApplication::appID, dsRibbonButtonStyle_LargeWithText, L"Hello", tb_Hello_id, &dsRibbonCmdBtn1 );                            
                        }
                    }
                }
            }
        }
    }
}

void RibbonApplication::RemoveUserInterfaceAndCommands()
{
    dsObjectPtrArray dsWSArr;
    dsWorkspace_ptr dsWorkspace;
    application->GetWorkspaces( dsUIState_Document, &dsWSArr );
    for( int i = 0; i < dsWSArr.getSize(); ++i )
    {
        dsWorkspace_ptr dsWorkspace( (dsWorkspace_c*)dsWSArr[i] );
        if ( dsWorkspace )
        {
            dsString nameWS;
            dsWorkspace->get_Name( &nameWS );
            if ( nameWS.Compare( L"SampleWorkSpace" ) == 0 )
            {
                dsObjectPtrArray dsObjArr;
                dsWorkspace->GetRibbonTabs( &dsObjArr );
                for( int i = 0; i < dsObjArr.getSize(); ++i )
                {
                    dsRibbonTab_ptr ribbonTab( (dsRibbonTab_c*)dsObjArr[i] );
                    if( ribbonTab )
                    {
                        dsObjectPtrArray dsRbPanelsArr;
                        ribbonTab->GetRibbonPanels( &dsRbPanelsArr );

                        for( int j = 0; j < dsRbPanelsArr.getSize(); ++j )
                        {
                            dsRibbonPanel_ptr dsRibbonPanel( (dsRibbonPanel_c*)dsRbPanelsArr[j] );
                            if( dsRibbonPanel )
                            {
                                dsRibbonPanel->Remove();
                                ribbonTab->Remove();
                            }
                        }
                    }
                }

                dsRibbonSystemMenu_c * dsRibbonSystemMenu;
                dsWorkspace->GetRibbonSystemMenu( &dsRibbonSystemMenu );

                dsRibbonSystemMenu->GetRibbonSystemMenuItems( &dsObjArr );
                int szRbSysMenu = dsObjArr.getSize();
                for( int i = 0; i < szRbSysMenu; ++i )
                {
                    dsRibbonSystemMenuItem_ptr dsRibbonSystemMenuItem( (dsRibbonSystemMenuItem_c*)dsObjArr[i] );
                    if ( dsRibbonSystemMenuItem )
                    {
                        dsRibbonItemType_e ItemType;
                        dsRibbonSystemMenuItem->GetType( &ItemType );
                        if( ItemType == dsRibbonItemType_SystemMenuItem )
                        {
                            dsString menuName;
                            dsRibbonSystemMenuItem->get_Name( &menuName );
                            dsString menuID;
                            dsRibbonSystemMenuItem->GetApiID( &menuID );
                            if ( menuName.Compare( L"Circle" ) == 0 && menuID.CompareNoCase( RibbonApplication::appID ) == 0  )
                            {
                                dsRibbonSystemMenuItem->Remove();
                            }
                            else if ( menuName.Compare( L"Line" ) == 0 && menuID.CompareNoCase( RibbonApplication::appID ) == 0)
                            {
                                dsRibbonSystemMenuItem->Remove();
                            }
                            else if ( menuName.Compare( L"PolyLine" ) == 0 && menuID.CompareNoCase( RibbonApplication::appID ) == 0)
                            {
                                dsRibbonSystemMenuItem->Remove();
                            }
                            else if ( menuName.Compare( L"Xline" ) == 0 && menuID.CompareNoCase( RibbonApplication::appID ) == 0)
                            {
                                dsRibbonSystemMenuItem->Remove();
                            }
                            else if ( menuName.Compare( L"Ellipse" ) == 0 && menuID.CompareNoCase( RibbonApplication::appID ) == 0)
                            {
                                dsRibbonSystemMenuItem->Remove();
                            }
                        }
                    }
                }

                dsRibbonQuickAccessBar_c * dsRibbonQuickAccessBar;    
                dsWorkspace->GetRibbonQuickAccessBar( &dsRibbonQuickAccessBar );

                dsObjectPtrArray dsObjQABArr;
                dsRibbonQuickAccessBar->GetRibbonQuickAccessBarItems(&dsObjQABArr);

                dsRibbonItemType_e ItemType;
                dsRibbonQuickAccessBar->GetType( &ItemType );
                if ( ItemType == dsRibbonItemType_QuickAccessBar )
                {
                    szRbSysMenu = dsObjQABArr.getSize();
                    for( int i = 0; i < szRbSysMenu; ++i )
                    {
                        dsRibbonQuickAccessBarItem_ptr dsRibbonQuickAccessBarItem( (dsRibbonQuickAccessBarItem_c*)dsObjQABArr[i] );
                        if ( dsRibbonQuickAccessBarItem )
                        {
                            dsRibbonItemType_e ItemType;
                            dsRibbonQuickAccessBarItem->GetType( &ItemType );
                            if( ItemType == dsRibbonItemType_QuickAccessBarItem )
                            {
                                dsString QABID;
                                dsRibbonQuickAccessBarItem->GetApiID( &QABID );
                                bool bEnable = true;
                                dsRibbonQuickAccessBarItem->get_Enabled( &bEnable );
                                if ( QABID.Compare( RibbonApplication::appID ) == 0)
                                {
                                    dsRibbonQuickAccessBarItem->Remove();
                                }
                            }
                        }
                    }
                }
                dsWorkspace->Remove();
            }
            else if ( nameWS.Compare( L"Drafting and Annotation" ) == 0)
            {
                dsObjectPtrArray dsObjArr;
                dsWorkspace->GetRibbonTabs( &dsObjArr );
                for( int i = 0; i < dsObjArr.getSize(); ++i )
                {
                    dsRibbonTab_ptr ribbonTab( (dsRibbonTab_c*)dsObjArr[i] );
                    if( ribbonTab )
                    {
                        dsString name;
                        ribbonTab->get_Name( &name );
                        dsString displayText;
                        ribbonTab->get_DisplayText( &displayText );
                        dsString apiID;
                        ribbonTab->GetApiID(&apiID);
                        if ( name.CompareNoCase( L"RibbonSampleTab") == 0 && 
                            displayText.CompareNoCase( L"RibbonSampleTab") == 0 && 
                            apiID.CompareNoCase(RibbonApplication::appID) == 0 )
                        {
                            dsObjectPtrArray dsRbPanelsArr;
                            ribbonTab->GetRibbonPanels( &dsRbPanelsArr );

                            for( int j = 0; j < dsRbPanelsArr.getSize(); ++j )
                            {
                                dsRibbonPanel_ptr dsRibbonPanel( (dsRibbonPanel_c*)dsRbPanelsArr[j] );
                                if( dsRibbonPanel )
                                {
                                    dsRibbonItemType_e ItemType;
                                    dsRibbonPanel->GetType( &ItemType );

                                    if( ItemType == dsRibbonItemType_Panel )
                                    {
                                        dsRibbonPanel->get_Name( &name );
                                        dsString displayText;
                                        dsRibbonPanel->get_DisplayText( &displayText );
                                        if ( name.CompareNoCase( L"SamplePannel" ) == 0 && displayText.CompareNoCase( L"SamplePannel" ) == 0 )
                                        {
                                            dsRibbonRow_ptr dsRibbonRow;
                                            dsRibbonPanel->GetRibbonRow( &dsRibbonRow );
                                            if ( dsRibbonRow )
                                            {
                                                dsRibbonRow->Remove();
                                                dsRibbonPanel->RemoveFromTab(L"Manage");
                                                dsRibbonPanel->Remove();
                                                ribbonTab->Remove();
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        else if ( name.CompareNoCase( L"Manage") == 0 )
                        {
                            dsObjectPtrArray dsRibbonPanelsArr;
                            ribbonTab->GetRibbonPanels(&dsRibbonPanelsArr);
                            for( int i = 0; i < dsRibbonPanelsArr.getSize(); ++i )
                            {
                                dsRibbonPanel_ptr dsRibbonPanel( (dsRibbonPanel_c*)dsRibbonPanelsArr[i] );
                                if ( dsRibbonPanel )
                                {
                                    dsString panelName;
                                    dsRibbonPanel->GetApiID(&panelName);
                                    if( panelName.Compare(L"ID_PanelMacro") == 0 )
                                    {
                                        dsRibbonRow_ptr dsRibbonRow;
                                        dsRibbonPanel->GetRibbonRow( &dsRibbonRow );

                                        dsObjectPtrArray dsRibbonRowArr;
                                        dsRibbonRow->GetRibbonRowItems( &dsRibbonRowArr );
                                        for( int i = 0; i < dsRibbonRowArr.getSize(); ++i )
                                        {
                                            dsRibbonRowItem_ptr dsRibbonRowItem( (dsRibbonRowItem_c*)dsRibbonRowArr[i] );
                                            dsRibbonItemType_e ItemType;
                                            dsRibbonRowItem->GetType(&ItemType);
                                            if( ItemType == dsRibbonItemType_CommandButton )
                                            {
                                                dsString name;
                                                dsRibbonRowItem->get_Name(&name);
                                                if(name.Compare( L"Hello") == 0)
                                                {
                                                    dsRibbonRowItem->Remove();
                                                }
                                            }
                                        }                         
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

ImplementApplicationOptionStringChangeNotifyHook(RibbonApplication)
ImplementApplicationCommandPostNotifyHook(RibbonApplication)

bool RibbonApplication::ApplicationOptionStringChangeNotify( dsApplicationOptionString_e Option )
{
    return true;
}

bool RibbonApplication::CommandPostNotify(const dsString&  CommandName,dsDocument_c * Document)
{
    return true;
}

//dsString RibbonApplication::q2d( const QString &s )
//{
//    return dsString( s.toStdWString().c_str() );
//}
//
//QString RibbonApplication::d2q( const dsString &s )
//{
//    return QString::fromWCharArray( (const wchar_t*) s );
//}

#ifdef DS_WIN
Ribbon_EXPORT bool connectToDraftSight(int cookie, dsApplication_c *dsApp)
#else //DS_WIN
extern "C" Menu_EXPORT bool connectToDraftSight(int cookie, dsApplication_c *dsApp)
#endif //DS_WIN
{
    if (!globalMenuApplication)
    {
        Options::instance().application = dsApp;
        Options::instance().ApiUuid = RibbonApplication::appID;
        globalMenuApplication = new RibbonApplication(dsApp);
        globalMenuApplication->CreateUserInterfaceAndCommands();
    }
    return globalMenuApplication;
}

#ifdef DS_WIN
Ribbon_EXPORT bool disconnectFromDraftSight()
#else //DS_WIN
extern "C" Ribbon_EXPORT bool disconnectFromDraftSight()
#endif //DS_WIN
{
    if (globalMenuApplication)
    {
        globalMenuApplication->RemoveUserInterfaceAndCommands();
        Options::instance().application->RemoveUserInterface(
            RibbonApplication::appID);
        delete globalMenuApplication;
        globalMenuApplication = 0;
    }
    return true;
}

#ifdef DS_WIN
Ribbon_EXPORT bool HasSignedByDraftSight(dsString *sId1, int *iId2, int *iKey1, int *iKey2)
#else //DS_WIN
extern "C" Ribbon_EXPORT bool HasSignedByDraftSight(dsString *sId1, int *iId2, int *iKey1, int *iKey2)
#endif //DS_WIN
{
    *sId1 = dsString( L"6E7715A3-DE7C-46ed-A83D-54EE25241B73" );
    return true;
}
