#include "stdafx.h"
#include <QMessageBox>
#include "dsAddinConnection.h"

ReactorsApplication *globalReactorsApplication = 0;
const dsString ReactorsApplication::appID = L"A1218497-6BB8-42B9-8490-1887DD764AF3";

void ReactorsApplication::ReferenceOpenDocs()
{
    dsObjectPtrArray documents;
    application->GetDocuments(&documents);
    for (int doc = 0; doc < documents.getSize(); ++doc)
        m_documents.push_back(new DsAddinDocument((dsDocument_c*)documents[doc]));
}

ImplementApplicationFileNewNotifyHook(ReactorsApplication)
ImplementApplicationFileOpenPreNotifyHook(ReactorsApplication)
ImplementApplicationFileOpenPostNotifyHook(ReactorsApplication)
ImplementApplicationActiveDocumentChangedNotifyHook(ReactorsApplication)
ImplementApplicationDestroyNotifyHook(ReactorsApplication)

bool ReactorsApplication::FileNewNotify(dsDocument_c* docIn) 
{
#ifdef DS_WIN
    if (m_documents.size() > 0 )
    {
        QMessageBox box(
            QMessageBox::Information,
            tr("Reactors sample"),
            tr("dsApplication hook: ReactorsApplication::FileNewNotify()"),
            QMessageBox::Ok);
        box.exec();
    }
#endif
    m_documents.push_back(new DsAddinDocument (docIn));
    
    return true;
}

bool ReactorsApplication::FileOpenPreNotify(dsString fileName, dsDocumentOpenOption_e Option) 
{ 
    QMessageBox box(
        QMessageBox::Information,
        tr("Reactors sample"),
        tr("dsApplication hook: ReactorsApplication::FileOpenPreNotify()"),
        QMessageBox::Ok);
    box.exec();
    return true; 
}

bool ReactorsApplication::ActiveDocumentChangedNotify()
{
    m_documents.remove_if(destroyClosedDocument);
#ifdef Q_OS_MAC
    if (m_documents.size() > 1 )
#endif
    {
        QMessageBox box(
            QMessageBox::Information,
            tr("Reactors sample"),
            tr("dsApplication hook: ReactorsApplication::ActiveDocumentChangedNotify()"),
            QMessageBox::Ok);
        box.exec();
    }
    
    return true; 
}

bool ReactorsApplication::FileOpenPostNotify(dsDocument_c *docIn)
{
    m_documents.push_back(new DsAddinDocument (docIn));
    QMessageBox box(
        QMessageBox::Information,
        tr("Reactors sample"),
        tr("dsApplication hook: ReactorsApplication::FileOpenPostNotify()"),
        QMessageBox::Ok);
    box.exec();
    return true; 
}

bool ReactorsApplication::DestroyNotify(void)
{
    QMessageBox box(
        QMessageBox::Information,
        tr("Reactors sample"),
        tr("dsApplication hook: ReactorsApplication::DestroyNotify()"),
        QMessageBox::Ok);
    box.exec();
    return true;
}


#ifdef DS_WIN
Reactors_EXPORT bool connectToDraftSight(int cookie, dsApplication_c *dsApp)
#else //DS_WIN
extern "C" Reactors_EXPORT bool connectToDraftSight(int cookie, dsApplication_c *dsApp)
#endif //DS_WIN
{
    if (!globalReactorsApplication)
    {
        globalReactorsApplication = new ReactorsApplication(dsApp);
        globalReactorsApplication->ReferenceOpenDocs();
    }
    return globalReactorsApplication;
}

#ifdef DS_WIN
Reactors_EXPORT bool disconnectFromDraftSight()
#else //DS_WIN
extern "C" Reactors_EXPORT bool disconnectFromDraftSight()
#endif //DS_WIN
{
    if (globalReactorsApplication)
    {
        delete globalReactorsApplication;
        globalReactorsApplication = 0;
    }

    return true;
}

#ifdef DS_WIN
Reactors_EXPORT bool HasSignedByDraftSight(dsString *sId1, int *iId2, int *iKey1, int *iKey2)
#else //DS_WIN
extern "C" Reactors_EXPORT bool HasSignedByDraftSight(dsString *sId1, int *iId2, int *iKey1, int *iKey2)
#endif //DS_WIN
{
    *sId1 = dsString(L"315763B3-9C4E-42EC-9ABD-48F889B14E36");
    return true;
}
