#include "CommandMyPrint.h"
#include "dsCommandMessage_c.h"
#include "dsPrintManager_c.h"
#include <sstream>

bool CommandMyPrint::ExecuteNotify()
{
     // Get command line interface
    dsCommandMessage_ptr commandline;
    application->GetCommandMessage(&commandline);

    dsDocument_ptr document;
    application->GetActiveDocument(&document);   

    dsDoubleArray dblArray;
    application->Zoom( dsZoomRange_Fit, dblArray, dblArray );

    dsStringArray arraySheet;
    arraySheet.clear();

    bool result = false;

#ifdef DS_WIN
    dsString sLayoutName;    
    commandline->PromptForString( true, L"Specify sheet name", L"", &sLayoutName, &result);

    wchar_t *del = L",";

    wchar_t *cName = new wchar_t[ sLayoutName.getSize() +1 ];
    const wchar_t* str =  (const wchar_t*)sLayoutName;

    wcscpy( cName, str); 
    
    wchar_t *token = wcstok( cName, del );

    while( token )
    {
        arraySheet.add( token );
        token = wcstok( 0, del );
    }

    if( 0 != cName )
    {
        delete[] cName;
        cName = 0;
    }

#endif

    dsString keyword;

    dsStringArray globalKeywords;
    globalKeywords.add(L"_PNG");
    globalKeywords.add(L"_JPG");
    globalKeywords.add(L"_PDF");    

    dsStringArray localKeywords;
    localKeywords.add(L"PNG");
    localKeywords.add(L"JPG");
    localKeywords.add(L"PDF");

    dsPromptResultType_e prompt_result;
    commandline->PromptForKeyword2(
        L"Specify printer name",
        L"",
        globalKeywords,
        localKeywords,
        0,
        localKeywords[2],
        &keyword,
        &prompt_result);
    if (prompt_result == dsPromptResultType_Cancel)
        return false;
    if (prompt_result != dsPromptResultType_Keyword)
        return false ;

    dsString printerName;
    dsString sPath;
    if (keyword.CompareNoCase(L"_PNG") == 0)
    {
        printerName = localKeywords[0];
    }
    else if (keyword.CompareNoCase(L"_JPG") == 0)
    {
        printerName = localKeywords[1];
    }
    else if (keyword.CompareNoCase(L"_PDF") == 0)
    {
        printerName = localKeywords[2];
    }
       
    result = false;
    commandline->PromptForString( true, L"Specify file name", L"", &sPath, &result);

    dsPrintManager_ptr dsPrintManager;
    application->GetPrintManager( &dsPrintManager );

    dsPrintManager->put_Printer( printerName );
    dsPrintManager->put_PaperSize( L"ISO expand A0 (1189.00 x 841.00 MM)" );
    dsPrintManager->put_ScaleToFit(true);
    dsPrintManager->put_ScaleLineWeight(true);
    dsPrintManager->put_Orientation(dsPrintOrientation_Landscape);
    dsPrintManager->SetPrintRange(dsPrintRange_AllGeometry, L"",false, 0, 0, 0, 0);

    dsString styleTable = L"monochrome.ctb";
    dsPrintManager->put_StyleTable(styleTable);

    dsPrintManager->put_UseAssignedLineWeight( true );
    dsPrintManager->put_UseAssignedPrintStyle( true );

    dsPrintManager->SetSheets( arraySheet );

    dsPrintManager->PrintOut(1, sPath );

    return true;
}
