#include "stdafx.h"
#include "Options.h"
#include "dsAddinConnection.h"

MenuApplication *globalMenuApplication = 0;
const dsString MenuApplication::appID = L"1C85DA6C-0445-4844-A66F-A048A5787A68";

void MenuApplication::CreateUserInterfaceAndCommands()
{
    // 1 - First register your command here
    //     (for invoking the command from the command line)
    m_CommandHello.createAndRegisterCommand();

    // Menu should be between "Modify" and "Tools" menus
    const int USERMENU_POSITION = 9;

    // Create user menu
    dsMenuItem_ptr menu;
    application->AddMenu(
        MenuApplication::appID,
        dsUIState_Document,
        USERMENU_POSITION,
        L"MenuSample",
        &menu);
    if (!menu)
        return;
    long menu_position = 1;

    // Create toolbar
    dsToolbar_ptr toolbar;
    application->AddToolbar(
        MenuApplication::appID,
        dsUIState_Document,
        L"MenuSample",
        &toolbar);
    if (!toolbar)
        return;
    long toolbar_position = 1;

    // 2 - Then append your command here, where you see fit in the menus.
    //     You can also create a new menu.

    m_CommandHello.createUserCommand();
    m_CommandHello.insert(menu, menu_position++);
    m_CommandHello.insert(toolbar, toolbar_position++);
}

ImplementApplicationOptionStringChangeNotifyHook(MenuApplication)
ImplementApplicationCommandPostNotifyHook(MenuApplication)

bool MenuApplication::ApplicationOptionStringChangeNotify( dsApplicationOptionString_e Option )
{
    if( Option == dsApplicationOptionString_SetWSCURRENT )        
    {
        dsApplicationOptions_c *appOption;
        application->GetApplicationOptions(&appOption);
        dsString value;
        dsGetApplicationOptionResult_e getResult;
        appOption->GetApplicationOptionString( dsApplicationOptionString_SetWSCURRENT, &value, &getResult );

        bool bContain = false;
        for (unsigned int i = 0; m_WorkSpaces.getSize() > i; ++i )
        {
            dsString sWorkSpace = m_WorkSpaces.getSize() > 0 ? m_WorkSpaces[i] : dsString();
            if ( sWorkSpace.CompareNoCase( value) == 0 )
            {
                bContain = true;
                break;
            }            
        }

        if ( bContain == false )
        {
            CreateUserInterfaceAndCommands();
            m_WorkSpaces.add( value );
        }
    }
    return true;
}

bool MenuApplication::CommandPostNotify(const dsString&  CommandName,dsDocument_c * Document)
{
    if ( CommandName.CompareNoCase(L"_DOCINIT") == 0 || CommandName.CompareNoCase(L"_ADDINS") == 0)
    {
        dsApplicationOptions_c *appOption;
        application->GetApplicationOptions(&appOption);
        dsString value;
        dsGetApplicationOptionResult_e getResult;
        appOption->GetApplicationOptionString( dsApplicationOptionString_SetWSCURRENT, &value, &getResult );
        bool bContain = false;
        for (unsigned int i = 0; m_WorkSpaces.getSize() >= i; ++i )
        {
            dsString sWorkSpace = m_WorkSpaces.getSize() > 0 ? m_WorkSpaces[i] : dsString();
            if ( sWorkSpace.CompareNoCase( value) == 0 )
            {
                bContain = true;
                break;
            }            
        }

        if ( bContain == false )
        {
            m_WorkSpaces.add( value );
        }
    }

    return true;
}

#ifdef DS_WIN
Menu_EXPORT bool connectToDraftSight(int cookie, dsApplication_c *dsApp)
#else //DS_WIN
extern "C" Menu_EXPORT bool connectToDraftSight(int cookie, dsApplication_c *dsApp)
#endif //DS_WIN
{
    if (!globalMenuApplication)
    {
        Options::instance().application = dsApp;
        Options::instance().ApiUuid = MenuApplication::appID;
        globalMenuApplication = new MenuApplication(dsApp);
        globalMenuApplication->CreateUserInterfaceAndCommands();
    }
    return globalMenuApplication;
}

#ifdef DS_WIN
Menu_EXPORT bool disconnectFromDraftSight()
#else //DS_WIN
extern "C" Menu_EXPORT bool disconnectFromDraftSight()
#endif //DS_WIN
{
    if (globalMenuApplication)
    {
        Options::instance().application->RemoveUserInterface(
            MenuApplication::appID);
        delete globalMenuApplication;
        globalMenuApplication = 0;
    }
    return true;
}

#ifdef DS_WIN
Menu_EXPORT bool HasSignedByDraftSight(dsString *sId1, int *iId2, int *iKey1, int *iKey2)
#else //DS_WIN
extern "C" Menu_EXPORT bool HasSignedByDraftSight(dsString *sId1, int *iId2, int *iKey1, int *iKey2)
#endif //DS_WIN
{
    *sId1 = dsString( L"6E7715A3-DE7C-46ed-A83D-54EE25241B73" );
    return true;
}
