#ifndef DS_ADDIN_CONNECTION_H
#define DS_ADDIN_CONNECTION_H

/*
Sample Name: EntityPreviewDemo

Sample Description:
    This sample demonstrates a preview of the current drawing

Usage:
    This example has one command, which can be invoked using either the
    command line or by using the menu "EntityPreviewDemo".

    _ENTITYPREVIEWDEMO "Select Preview Range"
        Opens a modal dialog showing the preview of the current drawing.

Overview:
    Put in a few words, this add-in consists of the following parts:

    Graphical User Interface:
        The class EntityPreviewDialog (.h, .cpp, .ui) is the GUI of this
        add-in. It appears as a local variable in CommandEntityPreviewDemo::
        ExecuteNotify(), embedded in a modal dialog.

    Functionality:
        Everything interesting happens in this add-in's sole command's
        body, CommandEntityPreviewDemo::ExecuteNotify(). First it creates
        four previews using dsApplication_c::GetPreviewOfEntities():
            - All Geometry
            - Current View
            - Named View
            - Specify Window
        Then a modal EntityPreviewDialog shows up, and the user is can
        choose which preview they want to look at.

    Command classes:
        _ENTITYPREVIEWDEMO (class CommandEntityPreviewDemo) derives from
        CommandBase. This base class provides an interface for both,
        registering a command to be used from the command line via
        CommandBase::registerCommand() as well as putting a command into a
        menu item via CommandBase::createUserCommand(), so done in
        EntityPreviewDemoApplication::CreateUserInterfaceAndCommands().

    Globally available options:
        This singleton Options class holds a globally accessible pointer
        to the application as well as the UUID of this add-in. You can add
        any data that is ought to be available throughout this program.

        Furthermore, there is the miscellaneous.h, a collection of useful
        functions for converting between dsAPI and Qt classes. These
        functions are used throughout the add-in.

Notable dsAPI functions used:
        dsApplication_c::GetPreviewOfEntities()
*/

#include "dsApplication_c.h"
#include "dsInterfacePtr.h"
#include "EntityPreviewDemoGlobal.h"

// You can append new commands like this:
// 1 - Append the header file here.
// 2 - Add the command as a private member of EntityPreviewDemoApplication.
// 3 - Go to EntityPreviewDemoApplication::CreateUserInterfaceAndCommands() and:
//     1 - Register your command using the registerCommand()
//         (then the command can be invoked from the command line).
//     2 - If it makes sense, add it to the user menu
//         (then the command can be invoked from the user menu as well).
#include "commands/CommandEntityPreviewDemo.h"

class EntityPreviewDemo_EXPORT EntityPreviewDemoApplication
{
public:
    EntityPreviewDemoApplication(dsApplication_c *dsApp) : application(dsApp) {}
    void CreateUserInterfaceAndCommands();
    static const dsString appID;

private:
    dsApplication_ptr application;
    CommandEntityPreviewDemo m_CommandEntityPreviewDemo;
};

#endif // DS_ADDIN_CONNECTION_H
