#include "stdafx.h"

#include "Options.h"
#include "dsAddinConnection.h"

EntityPreviewDemoApplication *globalEntityPreviewDemo = 0;
const dsString EntityPreviewDemoApplication::appID = L"B70E6670-D287-4E1F-80BD-455508828264";

void EntityPreviewDemoApplication::CreateUserInterfaceAndCommands()
{
    // 1 - First register your command here
    //     (for invoking the command from the command line)
    m_CommandEntityPreviewDemo.createAndRegisterCommand();

    // Menu should be between "Modify" and "Tools" menus
    const int USERMENU_POSITION = 9;

    // Create user menu
    dsMenuItem_ptr menu;
    application->AddMenu(
        EntityPreviewDemoApplication::appID,
        dsUIState_Document,
        USERMENU_POSITION,
        L"EntityPreviewDemo",
        &menu);
    if (!menu)
        return;
    long menu_position = 1;

    // Create toolbar
    dsToolbar_ptr toolbar;
    application->AddToolbar(
        EntityPreviewDemoApplication::appID,
        dsUIState_Document,
        L"EntityPreviewDemo",
        &toolbar );
    if (!toolbar)
        return;
    long toolbar_position = 1;

    // 2 - Then append your command here, where you see fit in the menu.
    //     You can also create a new menu.

    m_CommandEntityPreviewDemo.createUserCommand();
    m_CommandEntityPreviewDemo.insert(menu, menu_position++);
    m_CommandEntityPreviewDemo.insert(toolbar, toolbar_position++);
}

#ifdef DS_WIN
EntityPreviewDemo_EXPORT bool connectToDraftSight(int cookie, dsApplication_c *dsApp)
#else //DS_WIN
extern "C" EntityPreviewDemo_EXPORT bool connectToDraftSight(int cookie, dsApplication_c *dsApp)
#endif //DS_WIN
{
    if (!globalEntityPreviewDemo)
    {
        Options::instance().application = dsApp;
        Options::instance().ApiUuid = EntityPreviewDemoApplication::appID;
        globalEntityPreviewDemo = new EntityPreviewDemoApplication(dsApp);
        globalEntityPreviewDemo->CreateUserInterfaceAndCommands();
    }
    return globalEntityPreviewDemo;
}

#ifdef DS_WIN
EntityPreviewDemo_EXPORT bool disconnectFromDraftSight()
#else //DS_WIN
extern "C" EntityPreviewDemo_EXPORT bool disconnectFromDraftSight()
#endif //DS_WIN
{
    if (globalEntityPreviewDemo)
    {
        Options::instance().application->RemoveUserInterface(
            EntityPreviewDemoApplication::appID);
        delete globalEntityPreviewDemo;
        globalEntityPreviewDemo = 0;
    }
    return true;
}

#ifdef DS_WIN
EntityPreviewDemo_EXPORT bool HasSignedByDraftSight(dsString *sId1, int *iId2, int *iKey1, int *iKey2)
#else //DS_WIN
extern "C" EntityPreviewDemo_EXPORT bool HasSignedByDraftSight(dsString *sId1, int *iId2, int *iKey1, int *iKey2)
#endif //DS_WIN
{
    *sId1 = dsString( L"A260970C-2CEB-4e83-ACAF-876E958A33AE" );
    return true;
}
