#include "stdafx.h"
#include "../EntityPreviewDialog.h"
#include "CommandEntityPreviewDemo.h"

bool CommandEntityPreviewDemo::ExecuteNotify()
{
    dsDocument_ptr document;
    application->GetActiveDocument(&document);
    dsModel_ptr model;
    document->GetModel(&model);
    dsSketchManager_ptr sketchmanager;
    model->GetSketchManager(&sketchmanager);

    dsCircle_ptr circle;
    sketchmanager->InsertCircle(0.922622, 3.25193, 0, 2.79365, &circle);
    dsCircleArc_ptr arc;
    sketchmanager->InsertArc(0.80, 6.79, 0, 6, 303, 236, &arc);
    dsLine_ptr line;
    sketchmanager->InsertLine(1, 2, 0, 3, 2, 0, &line);

    dsObjectPtrArray entities;
    entities.add(circle);
    entities.add(arc);
    entities.add(line);

    dsMathPoint_ptr win_min;
    dsMathPoint_ptr win_max;
    dsMathUtility_ptr math;
    application->GetMathUtility(&math);
    math->CreatePoint(0, 0, 0, &win_min);
    math->CreatePoint(50, 50, 0, &win_max);

    dsByteArray bitmap;
    bool result;

    // All geometry
    application->GetPreviewOfEntities(
        entities,
        dsBitmapFormat_JPEG,
        dsPreviewRange_AllGeometry, 
        L"Test_NamedView1",
        win_min,
        win_max,
        300,
        300,
        &bitmap,
        &result);
    QImage imageAllGeometry;
    imageAllGeometry.loadFromData((const uchar*)bitmap.getptr(), bitmap.getSize());

    // Current view
    application->GetPreviewOfEntities(
        entities,
        dsBitmapFormat_JPEG,
        dsPreviewRange_CurrentView, 
        L"Test_NamedView1",
        win_min,
        win_max,
        300,
        300,
        &bitmap,
        &result);
    QImage imageCurrentView;
    imageCurrentView.loadFromData((const uchar*)bitmap.getptr(), bitmap.getSize());

    // Named view
    dsViewManager_ptr viewmanager;
    document->GetViewManager(&viewmanager);
    dsModelNamedView_ptr view;
    dsCreateObjectResult_e create_object_result;
    viewmanager->CreateModelNamedView(
        L"ModelNamedView1",
        L"ModelNamedViewClass",
        makeArray<dsDoubleArray,double>(3, 0.0, 0.0, 0.0), 
        makeArray<dsDoubleArray,double>(3, 25.0, 25.0, 0.0),
        &view,
        &create_object_result);

    application->GetPreviewOfEntities(
        entities,
        dsBitmapFormat_JPEG,
        dsPreviewRange_NamedView, 
        L"ModelNamedView1",
        win_min, win_max,
        300,
        300,
        &bitmap,
        &result);
    QImage imageNamedView;
    imageNamedView.loadFromData((const uchar*)bitmap.getptr(), bitmap.getSize());

    // Specified window
    application->GetPreviewOfEntities(
        entities,
        dsBitmapFormat_JPEG,
        dsPreviewRange_SpecifyWindow, 
        L"Test_NamedView1",
        win_min,
        win_max,
        300,
        300,
        &bitmap,
        &result);
    QImage imageSpecifyWindow;
    imageSpecifyWindow.loadFromData((const uchar*)bitmap.getptr(), bitmap.getSize());

    // Show dialog
    EntityPreviewDialog w(
        &imageAllGeometry,
        &imageCurrentView,
        &imageNamedView,
        &imageSpecifyWindow);
    w.exec();

    return true;
}
