#ifndef DS_ADDIN_CONNECTION_H
#define DS_ADDIN_CONNECTION_H

/*
Sample Name: DrawingToImage

Sample Description:
    This sample demonstrates how to export drawing files (.dwg, .dxf) to
    image files (.png). It simply opens a file browser dialog asking the
    user to specify the folder containing the drawings. It accepts the
    folder and converts all drawings to portable network graphics.

Usage:
    This example has one command, which can be invoked using the command
    line, using the menu "DrawingToImage" or from a toolbar.
        
    _DRAWINGTOIMAGE "Drawing to image"
        Opens a modal dialog you can use to insert the text.

Overview:
    Put in a few words, this add-in consists of the following parts:

    Graphical User Interface:
        The class DrawingRootpathDialog is the GUI of this add-in. It
        appears as a local variable in
        CommandDrawingToImage::ExecuteNotify().

    Functionality:
        The actual conversion job is done by the class Converter. It
        iterates over the given list of files, loads them as normal
        documents, invokes dsDocumentExporter_c::ExportToPng() and closes
        that document again.

    Command classes:
        _DRAWINGTOIMAGE (class CommandDrawingToImage) registers itself on
        construction so it can be called from the command line and adds
        itself to a menu and to a toolbar, so done in
        DrawingToImage::CreateUserInterfaceAndCommands().

    Furthermore, there is the miscellaneous.h, a collection of useful
    functions for converting between dsAPI and Qt classes. These functions
    are used throughout the add-in.

Notable dsAPI functions used:
    dsApplication_c::OpenDocument()
    dsDocumentExporter_c::ExportToPng()
*/

#include "dsApplication_c.h"

#include "DrawingToImage_global.h"
#include "CommandDrawingToImage.h"

class DrawingToImage_EXPORT DrawingToImageApplication 
{
public:
    DrawingToImageApplication(dsApplication_c *dsApp);
    dsApplication_c* getDsApp() { return application; } 
    static const dsString m_AddinGUID;

    void CreateUserInterfaceAndCommands();

private:
    dsApplication_ptr application;
    CommandDrawingToImage m_CommandDrawingToImage;
};

#endif // DS_ADDIN_CONNECTION_H
