#ifndef PATHEDIT_H
#define PATHEDIT_H

#include <QToolButton>
#include <QLineEdit>
#include <QFileDialog>

// This class provides a text field that can
// be used for selecting files or directories.
class PathEdit : public QLineEdit
{
    Q_OBJECT
public:
    PathEdit(QWidget *parent = 0);

    // Sets the file mode the dialog box is used with
    void setFileMode(QFileDialog::FileMode f) { m_filemode = f; }

    void setDialogPrompt(const QString &s) { m_dialog_prompt = s; }
    void setVisible(bool visible);

    QToolButton bt_select;

protected:
    void resizeEvent(QResizeEvent*);

    QString m_dialog_prompt;
    QFileDialog::FileMode m_filemode;

protected slots:
    void on_bt_select_clicked();
};

#endif // PATHEDIT_H