#ifndef DrawingRootpathDialog_H
#define DrawingRootpathDialog_H

#include <QStringList>
#include <QDialog>
#include "ui_DrawingRootpathDialog.h"

class DrawingRootpathDialog : public QDialog
{
    Q_OBJECT

public:
    DrawingRootpathDialog(QWidget *parent = 0);
    QStringList getDrawings() const { return m_drawings; }

// The slots are automatically connected due to names convention.
// See also QMetaObject::connectSlotsByName(DrawingRootpathDialog);
private slots:
    void on_ed_path_textChanged( const QString &s );

private:
    Ui::DrawingRootpathDialog ui;

    // .dwg/.dwf files only
    QStringList m_filter;

    // This list will be returned via getDrawings()
    // when the dialog is closed.
    QStringList m_drawings;

    // Returns a list of .dwg/.dxf files directly located in path.
    QStringList drawings_in_directory(const QString &path);
};

#endif // DrawingRootpathDialog_H
