#include <QDirIterator>
#include "DrawingRootpathDialog.h"

DrawingRootpathDialog::DrawingRootpathDialog(QWidget *parent)
: QDialog(parent)
, m_filter(QString::fromLatin1(
    "*.dwg,*.Dwg,*.dWg,*.DWg,*.dwG,*.DwG,*.dWG,*.DWG,"
    "*.dxf,*.Dxf,*.dXf,*.DXf,*.dxF,*.DxF,*.dXF,*.DXF").split(","))
{
    ui.setupUi(this);
    ui.ed_path->setDialogPrompt(tr("Choose DWG/DXF root directory"));
    ui.ed_path->setFileMode(QFileDialog::DirectoryOnly);
}

void DrawingRootpathDialog::on_ed_path_textChanged( const QString &s )
{
    m_drawings.clear();
    if (!QDir(s).exists())
        return;

    // Iterate over all directories inside root, seek
    // for all drawings and re-populate m_drawings.
    m_drawings << drawings_in_directory(s);
    QDirIterator i(
        s,
        QDir::Dirs | QDir::NoDotAndDotDot,
        QDirIterator::Subdirectories);
    while (i.hasNext())
        m_drawings << drawings_in_directory(i.next());
    ui.ed_log->append(tr("\"%1\"\ncontains %2 drawing(s).")
        .arg(s).arg(m_drawings.size()));
}

QStringList DrawingRootpathDialog::drawings_in_directory( const QString &path )
{
    QStringList result;
    QDir dir(path);
    if (dir.exists())
    {
        QStringList l = dir.entryList(
            m_filter,
            QDir::Files,
            QDir::Name | QDir::IgnoreCase);
        foreach (QString s, l)
            result << QString::fromLatin1("%1/%2").arg(path).arg(s);
    }
    return result;
}
