#include "stdafx.h"
#include "Options.h"
#include "dsAddinConnection.h"

DrawTableCommandApplication *globalDrawTableCommand = 0;
const dsString DrawTableCommandApplication::appID = L"2B679162-33F1-4e47-9ECD-D56032213ED5";

void DrawTableCommandApplication::CreateUserInterfaceAndCommands()
{
    // 1 - First register your command here
    //     (for invoking the command from the command line)
    m_CommandDrawTable.createAndRegisterCommand();
}

#ifdef DS_WIN
DrawTableCommand_EXPORT bool connectToDraftSight(int cookie, dsApplication_c *dsApp)
#else //DS_WIN
extern "C" DrawTableCommand_EXPORT bool connectToDraftSight(int cookie, dsApplication_c *dsApp)
#endif //DS_WIN
{
    if (!globalDrawTableCommand)
    {
        Options::instance().application = dsApp;
        Options::instance().ApiUuid = DrawTableCommandApplication::appID;
        globalDrawTableCommand = new DrawTableCommandApplication(dsApp);
        globalDrawTableCommand->CreateUserInterfaceAndCommands();
    }
    return globalDrawTableCommand;
}

#ifdef DS_WIN
DrawTableCommand_EXPORT bool disconnectFromDraftSight()
#else //DS_WIN
extern "C" DrawTableCommand_EXPORT bool disconnectFromDraftSight()
#endif //DS_WIN
{
    if (globalDrawTableCommand)
    {
        Options::instance().application->RemoveUserInterface(
            DrawTableCommandApplication::appID);
        delete globalDrawTableCommand;
        globalDrawTableCommand = 0;
    }
    return true;
}

#ifdef DS_WIN
DrawTableCommand_EXPORT bool HasSignedByDraftSight(dsString *sId1, int *iId2, int *iKey1, int *iKey2)
#else //DS_WIN
extern "C" DrawTableCommand_EXPORT bool HasSignedByDraftSight(dsString *sId1, int *iId2, int *iKey1, int *iKey2)
#endif //DS_WIN
{
    *sId1 = dsString( L"64F8008B-152F-408a-BE9B-2907DD47FC4B" );
    return true;
}
