#include "stdafx.h"
#include "Options.h"
#include "dsAddinConnection.h"

DrawCircleCommandApplication *globalDrawCircleCommand = 0;
const dsString DrawCircleCommandApplication::appID = L"2B679162-33F1-4e47-9ECD-D56032213ED5";

void DrawCircleCommandApplication::CreateUserInterfaceAndCommands()
{
    // 1 - First register your command here
    //     (for invoking the command from the command line)
    m_CommandDrawCircle.createAndRegisterCommand();
}

#ifdef DS_WIN
DrawCircleCommand_EXPORT bool connectToDraftSight(int cookie, dsApplication_c *dsApp)
#else //DS_WIN
extern "C" DrawCircleCommand_EXPORT bool connectToDraftSight(int cookie, dsApplication_c *dsApp)
#endif //DS_WIN
{
    if (!globalDrawCircleCommand)
    {
        Options::instance().application = dsApp;
        Options::instance().ApiUuid = DrawCircleCommandApplication::appID;
        globalDrawCircleCommand = new DrawCircleCommandApplication(dsApp);
        globalDrawCircleCommand->CreateUserInterfaceAndCommands();
    }
    return globalDrawCircleCommand;
}

#ifdef DS_WIN
DrawCircleCommand_EXPORT bool disconnectFromDraftSight()
#else //DS_WIN
extern "C" DrawCircleCommand_EXPORT bool disconnectFromDraftSight()
#endif //DS_WIN
{
    if (globalDrawCircleCommand)
    {
        Options::instance().application->RemoveUserInterface(
            DrawCircleCommandApplication::appID);
        delete globalDrawCircleCommand;
        globalDrawCircleCommand = 0;
    }
    return true;
}

#ifdef DS_WIN
DrawCircleCommand_EXPORT bool HasSignedByDraftSight(dsString *sId1, int *iId2, int *iKey1, int *iKey2)
#else //DS_WIN
extern "C" DrawCircleCommand_EXPORT bool HasSignedByDraftSight(dsString *sId1, int *iId2, int *iKey1, int *iKey2)
#endif //DS_WIN
{
    *sId1 = dsString( L"64F8008B-152F-408a-BE9B-2907DD47FC4B" );
    return true;
}
