#include "dsCommandMessage_c.h"
#include "dsMathUtility_c.h"
#include "dsMathPoint_c.h"
#include "dsMathVector_c.h"
#include "dsMathPlane_c.h"
#include "dsDocument_c.h"
#include "dsModel_c.h"
#include "dsSketchManager_c.h"
#include "dsCircle_c.h"
#include "dsInterfacePtr.h"
#include "CommandDrawCircle.h"

bool CommandDrawCircle::ExecuteNotify()
{
    // Get command line interface
    dsCommandMessage_c* commandline;
    application->GetCommandMessage(&commandline);

    // Let the user enter the circle's center point
    bool result;
    double centerX = 0.0, centerY = 0.0, centerZ = 0.0;
    if (commandline->PromptForPoint(L"Specify center point for circle", 
		&centerX, &centerY, &centerZ,&result) != DSRESULT_True || !result)
    {
        return false;
    }

    // Let the user enter a point on the circle
    dsMathUtility_c *math;
    application->GetMathUtility(&math);
    dsMathPlane_c *plane;
    math->CreateXYPlane(&plane);
    double circleX = 5, circleY = 0, circleZ = 0;
    if (commandline->PromptForPoint2(
        L"Specify point on circle",
        true,
        centerX, centerY, centerZ,
        &circleX, &circleY, &circleZ,
        plane,
        &result) != DSRESULT_True || !result)
    {
        return false;
    }

    // Calculate circle radius: do calculation using DSAPI geometry classes
    dsMathPoint_ptr center, on_circle;
    math->CreatePoint(centerX, centerY, centerZ, &center);
    math->CreatePoint(circleX, circleY, circleZ, &on_circle);
    on_circle->Subtract(center);
    dsMathVector_ptr radius_vector;
    on_circle->ConvertToVector(&radius_vector);
    double radius = 0;
    radius_vector->GetLength(&radius);

    // Add circle entity to drawing
    dsDocument_ptr document;
    application->GetActiveDocument(&document);
    dsModel_ptr model;
    document->GetModel(&model);
    dsSketchManager_ptr sketchmanager;
    model->GetSketchManager(&sketchmanager);
    dsCircle_ptr circle;
    sketchmanager->InsertCircle(centerX, centerY, centerZ, radius, &circle);

    return true;
}
