#ifndef DS_ADDIN_CONNECTION_H
#define DS_ADDIN_CONNECTION_H

/*
Sample Name: ContextMenu

Sample Description:
    This sample demonstrates how to add a command to a menu, to a toolbar
    and to a context menu in the dsAPI.

Usage:
    Right-clicking on the drawing window and click on
    ContextMenuSample -> ContextMenu :: Hello.

    _CMHELLO "ContextMenu :: Hello"
        The sole command is not important. It just says hello.

Overview:
    Functionality:
        We want to draw our attention to these four methods, as they create
        the command, the menu, the toolbar, the context menu entry and puts
        the command on each of them.
            * ContextMenuApplication::CreateUserInterfaceAndCommands()
            * CommandBase::insert(dsMenuItem_c *menu, const int &position)
            * CommandBase::insert(dsToolbar_c *toolbar, const int &position)
            * CommandBase::insert(dsContextMenuItem_c *context_menu, const int &position)
        
    Command classes:
        _CMHELLO (class CommandHello) derives from CommandBase. This base
        class provides an interface for both, registering a command to be
        used from the command line via CommandBase::registerCommand() as
        well as putting a command into a menu item via CommandBase::
        createUserCommand(), so done in ContextMenuApplication::
        CreateUserInterfaceAndCommands().

    Globally available options:
        This singleton Options class holds a globally accessible pointer
        to the application as well as the UUID of this add-in. You can add
        any data that is ought to be available throughout this program.

        Furthermore, there is the miscellaneous.h, a collection of useful
        functions for converting between dsAPI and Qt classes. These
        functions are used throughout the add-in.

Notable dsAPI functions used:
    dsApplication_c::AddMenu()
    dsApplication_c::AddToolbar()
    dsApplication_c::AddDefaultContextMenu()
    dsMenuItem_c::InsertMenuItem()
    dsToolbarItem_c::InsertToolbarItem()
    dsContextMenuItem_c::InsertMenuItem()
*/

#include "dsApplication_c.h"
#include "dsInterfacePtr.h"
#include "ContextMenu_global.h"

// You can append new commands like this:
// 1 - Append the header file here.
// 2 - Add the command as a private member of ContextMenuApplication.
// 3 - Go to bool ContextMenuApplication::CreateUserInterfaceAndCommands() and:
//     1 - Register your command using the registerCommand()
//         (then the command can be invoked from the command line).
//     2 - If it makes sense, add it to the user menu
//         (then the command can be invoked from the user menu as well).
#include "commands/CommandHello.h"

class ContextMenu_EXPORT ContextMenuApplication
{
public:
    ContextMenuApplication(dsApplication_c *dsApp) : application(dsApp) {}

    dsApplication_c* getDsApp() { return application; }
    void CreateUserInterfaceAndCommands();
    static const dsString appID;

private:
    dsApplication_ptr application;
    CommandHello m_CommandHello;
};
#endif // DS_ADDIN_CONNECTION_H
