#include "stdafx.h"
#include "Options.h"
#include "dsAddinConnection.h"

ContextMenuApplication *globalContextMenu = 0;
const dsString ContextMenuApplication::appID = L"10F9BC6E-A5A4-493a-82E6-B2EBFDEE6170";

void ContextMenuApplication::CreateUserInterfaceAndCommands()
{
    // 1 - First register your command here
    //     (for invoking the command from the command line)
    m_CommandHello.createAndRegisterCommand();

    // Menu should be between "Modify" and "Tools" menus
    const int USERMENU_POSITION = 9;

    // Create user menu
    dsMenuItem_ptr menu;
    application->AddMenu(
        ContextMenuApplication::appID,
        dsUIState_Document,
        USERMENU_POSITION,
        L"ContextMenuSample",
        &menu);
    if (!menu)
        return;
    long menu_position = 1;

    // Create toolbar
    dsToolbar_ptr toolbar;
    application->AddToolbar(
        ContextMenuApplication::appID,
        dsUIState_Document,
        L"ContextMenuSample",
        &toolbar);
    if (!toolbar)
        return;
    long toolbar_position = 1;

    // Create entry in default context menu
    dsInterfacePtr<dsContextMenuItem_c> context_menu; 
    application->AddDefaultContextMenu(
        ContextMenuApplication::appID,
        dsMenuItemType_Menu,
        L"ContextMenuSample",
        L"",
        &context_menu);
    long context_menu_position = 1;

    // 2 - Then append your command here, where you see fit in the menus.
    //     You can also create a new menu.

    m_CommandHello.createUserCommand();
    m_CommandHello.insert(menu, menu_position++);
    m_CommandHello.insert(toolbar, toolbar_position++);
    m_CommandHello.insert(context_menu, context_menu_position++);
}

#ifdef DS_WIN
ContextMenu_EXPORT bool connectToDraftSight(int cookie, dsApplication_c *dsApp)
#else //DS_WIN
extern "C" ContextMenu_EXPORT bool connectToDraftSight(int cookie, dsApplication_c *dsApp)
#endif //DS_WIN
{
    if (!globalContextMenu)
    {
        Options::instance().application = dsApp;
        Options::instance().ApiUuid = ContextMenuApplication::appID;
        globalContextMenu = new ContextMenuApplication(dsApp);
        globalContextMenu->CreateUserInterfaceAndCommands();
    }
    return globalContextMenu;
}

#ifdef DS_WIN
ContextMenu_EXPORT bool disconnectFromDraftSight()
#else //DS_WIN
extern "C" ContextMenu_EXPORT bool disconnectFromDraftSight()
#endif //DS_WIN
{
    if (globalContextMenu)
    {
        if (globalContextMenu->getDsApp())
        {
             globalContextMenu->getDsApp()->RemoveUserInterface(
                 ContextMenuApplication::appID);
        }
        delete globalContextMenu;
        globalContextMenu = 0;
    }
    return true;
}

#ifdef DS_WIN
ContextMenu_EXPORT bool HasSignedByDraftSight(dsString *sId1, int *iId2, int *iKey1, int *iKey2)
#else //DS_WIN
extern "C" ContextMenu_EXPORT bool HasSignedByDraftSight(dsString *sId1, int *iId2, int *iKey1, int *iKey2)
#endif //DS_WIN
{
    *sId1 = dsString( L"88A3BFD8-0360-4e80-AA96-DDA1C6B047BA" );
    return true;
}
