#ifndef MISCELLANEOUS_H
#define MISCELLANEOUS_H

//#include <QString>
//#include "dsConstants.h"
//#include "dsString.h"
#include "dsAttributeDefinition_c.h"
#include "dsAttributeInstance_c.h"
#include "dsObjectPtrArray.h"
#include "dsMathPoint_c.h"
#include "dsMathVector_c.h"
#include "dsMathUtility_c.h"
#include "dsApplication_c.h"

// Converts s to an integer.
int d2i(const dsString &s);
dsString getResistance( int i );

dsAttributeDefinition_c* get_attribute_definition( 
    dsAttributeInstance_c *attribute_instance, dsObjectPtrArray &attribute_definitions );

dsMathPoint_c* getMidPoint( dsMathUtility_c* pMathUtil, dsMathPoint_c* pt1, dsMathPoint_c* pt2 );

dsMathVector_c* createVector(dsMathUtility_c* pMathUtil, double x, double y, double z);
dsMathPoint_c* addPointToVector(dsMathUtility_c* pMathUtil, dsMathPoint_c* pPoint, dsMathVector_c* pMathVector);
dsMathPoint_c* createPoint(dsMathUtility_c* pMathUtil, double x, double y, double z);

class TBPoint3D
{
public:
    TBPoint3D()
    {
        x1 = 0.0;
        y1 = 0.0;
        z1 = 0.0;
    }
    TBPoint3D(double v1, double v2)
    {
        x1 = v1;
        y1 = v2;
        z1 = 0.0;
    }
    TBPoint3D(double v1, double v2,double v3)
    {
        x1 = v1;
        y1 = v2;
        z1 = v3;
    }
    double x()
    {
        return x1;
    }
    double y()
    {
        return y1;
    }
    double z()
    {
        return z1;
    }
    void setX(double value)
    {
        x1 = value;
    }
    void setY(double value)
    {
        y1 = value;
    }
    void setZ(double value)
    {
        z1 = value;
    }
    const TBPoint3D operator - (const TBPoint3D& point)
    {
        TBPoint3D tmpPoint;
        tmpPoint.x1 = x1 - point.x1;
        tmpPoint.y1 = y1 - point.y1;
        tmpPoint.z1 = z1 - point.z1;
        return tmpPoint;
    }
    bool operator == (const TBPoint3D& point)
    {
        if((x1 == point.x1) && (y1 == point.y1) && (z1 == point.z1))
        {
            return true;
        }
        else
        {
            return false;
        }
    }

private:
    double x1;
    double y1;
    double z1;
};
#endif // MISCELLANEOUS_H