#ifndef DS_ADDIN_CONNECTION_H
#define DS_ADDIN_CONNECTION_H

/*
Sample Name: SerialResistor

Sample Description:
    Using R = U / I, this sample calculates an appropriate resistor to be used
    for a series of LEDs in a circuit of given current and voltage. Furthermore
    this sample connects all elements in the aforementioned serial circuit.

Usage:
    This example has one command, which can be invoked using either the
    command line or by using the menu "SerialResistor".

    _SERIALRESISTOR
        Prompts to select all electrical components, serializes them and adds
        an appropiate resistor.

Overview:
    Put in a few words, this add-in consists of the following parts:

    Functionality:
        The actual job is done by the _SERIALRESISTOR command.

    Command classes:
        _SERIALRESISTOR derives from CommandBase. This base class provides
        an interface for both, registering a command to be used from the
        command line via CommandBase::registerCommand() as well as putting
        a command into a menu item via CommandBase::createUserCommand(), so
        done in SerialResistorApplication::CreateUserInterfaceAndCommands().

Interface used:
    dsBlockDefinition_c
    dsBlockInstance_c
    dsTracker_c
    dsMathPoint_c
*/

#include "dsApplication_c.h"
#include "dsInterfacePtr.h"
#include "SerialResistor_global.h"
#include "commands/CommandSerialResistor.h"

// You can append new commands like this:
// 1 - Append the header file here.
// 2 - Add the command as a private member of SerialResistorApplication.
// 3 - Go to bool SerialResistorApplication::CreateUserInterfaceAndCommands() and:
//     1 - Register your command using the registerCommand()
//         (then the command can be invoked from the command line).
//     2 - If it makes sense, add it to the user menu
//         (then the command can be invoked from the user menu as well).
class SerialResistor_EXPORT SerialResistorApplication 
{
public:
    SerialResistorApplication(dsApplication_c *dsApp) : application(dsApp){}

    dsApplication_c* getDsApp() { return application; } 
    void CreateUserInterfaceAndCommands();
    static const dsString appID;

private:
    dsApplication_ptr application;
    CommandSerialResistor m_CommandSerialResistor;
};

#endif // DS_ADDIN_CONNECTION_H
