#include "dsInterfacePtr.h"
#include "dsDocument_c.h"
#include "dsTextStyleManager_c.h"
#include "dsTextStyle_c.h"
#include "dsEntityHelper_c.h"

#include "Options.h"
#include "dsTextstyleCombobox.h"

void dsTextstyleCombobox::populate()
{
    clear();

    dsDocument_ptr doc;
    Options::instance().application->GetActiveDocument(&doc);
    if (!doc)
        return;

    dsTextStyleManager_ptr manager;
    doc->GetTextStyleManager(&manager);
    dsEntityHelper_ptr helper;
    Options::instance().application->GetEntityHelper(&helper);

    unsigned int active_style_index = 0;
    dsTextStyle_ptr active_style;
    manager->GetActiveTextStyle(&active_style);
    dsObjectPtrArray styles;
    manager->GetTextStyles(&styles);

    for (unsigned int i = 0; i < styles.getSize(); ++i)
    {
        dsTextStyle_c *style = (dsTextStyle_c*)styles[i];

        dsString name;
        style->get_Name(&name);
        addItem(d2q(name));

        bool same = false;
        helper->CompareObjects(active_style, style, &same);
        if (same)
            active_style_index = i;
    }

    if (styles.getSize() > 0)
        setCurrentIndex(active_style_index);
}
