#ifndef DSCOLORCOMBOBOX_H
#define DSCOLORCOMBOBOX_H

#include <QtWidgets/QComboBox>
#include "dsColor_c.h"
#include "dsInterfacePtr.h"

// This class provides a combo box for colors.
class dsColorCombobox : public QComboBox
{
    Q_OBJECT
public:
    dsColorCombobox(QWidget *parent = 0);
    dsColor_c* getColor() { return m_color; }

protected slots:
    void on_activated(int index);

protected:
    dsInterfacePtr<dsColor_c> m_color;
};

#endif // DSCOLORCOMBOBOX_H