#ifndef MISCELLANEOUS_H
#define MISCELLANEOUS_H

#include <QtCore/QString>
#include <QtCore/QStringList>
#include <QtCore/QByteArray>
#include <QtWidgets/QWidget>

#include "dsString.h"
#include "dsStringArray.h"
#include "dsByteArray.h"

// Lacking initializer lists, we have this hack here. Please use it with
// extreme caution! It converts a list of T to a corresponding dsTArray.
// Example: makeArray<dsDoubleArray, double>(3, 0.0, 1.0, 2.0) returns
//          a dsDoubleArray containing three values: 0, 1 and 2.
// Note   : Decommission this function, once C++11 is available.
template <typename dsTArray, typename T>
dsTArray makeArray(size_t length, ...)
{
    dsTArray result;
    va_list arguments;
    va_start(arguments, length);
    for (size_t i = 0; i < length; ++i)
        result.add(va_arg(arguments, T));
    va_end(arguments);
    return result;
}

// Sets a system variable:
// set variable=value
int setEnvironmentVariable(
    const QString &variable,
    const QString &value = QString());

// Returns the value of the specified environment variable or an
// empty string if that variable is not set in the environment.
QString getEnvironmentVariable(const QString &variable);

// Converts a QString into a dsString.
dsString q2d(const QString &s);

// Converts a QStringList into a dsStringArray.
dsStringArray q2d(const QStringList &l);

// Converts a QByteArray into a dsByteArray.
dsByteArray q2d(const QByteArray &a);

// Converts a dsString into a QString.
QString d2q(const dsString &s);

// Converts a dsStringArray into a QStringList.
QStringList d2q(const dsStringArray &l);

// Converts a dsByteArray into a QByteArray.
QByteArray d2q(const dsByteArray &a);

#endif // MISCELLANEOUS_H
