#ifndef COMMANDDIALOG_H
#define COMMANDDIALOG_H

#include <QCoreApplication>
#include "../Options.h"
#include "../miscellaneous.h"
#include "../CommandBase.h"

class CommandDialog : public CommandBase
{
    Q_DECLARE_TR_FUNCTIONS(CommandDialog)
public:
    CommandDialog() : CommandBase(Options::instance().application) {}
    const dsString groupName() const { return Options::instance().ApiUuid; }
    const dsString globalName() const { return L"_PWDIALOG"; }
    const dsString localName() const { return q2d(tr("PWDIALOG")); }
    const dsString Description() const { return q2d(tr("Opens the dialog for the text inserter")); }
    const dsString ItemName() const { return q2d(tr("Open text inserter")); }

    bool ExecuteNotify();
};

#endif // COMMANDDIALOG_H
