#ifndef TEXTINSERTER_H
#define TEXTINSERTER_H

#include <QString>
#include <QCoreApplication>

#include "dsString.h"
#include "dsConstants.h"
#include "dsColor_c.h"
#include "dsApplication_c.h"

// This class does the actual job of inserting the text and its bounding
// box with a given color, line style, line weight, and text style.
class TextInserter
{
    Q_DECLARE_TR_FUNCTIONS(TextInserter)
public:
    TextInserter(
        dsApplication_c *application,
        const QString &text,
        const double &x1,
        const double &y1,
        const double &z1,
        const double &x2,
        const double &y2,
        const double &z2,
        dsColor_c *color,
        const dsString &linestyle,
        const dsLineWeight_e &lineweight,
        const dsString &textstyle)
    : application(application)
    , m_text(text)
    , m_x1(x1), m_y1(y1), m_z1(z1)
    , m_x2(x2), m_y2(y2), m_z2(z2)
    , m_color(color)
    , m_linestyle(linestyle)
    , m_lineweight(lineweight)
    , m_textstyle(textstyle)
    {}

    bool insert();

protected:
    // Gives access to the application. You can retrieve access to the
    // command line, the current document, its model and its sketch
    // manager.
    dsApplication_c *application;

    // The text to be inserted.
    QString m_text;

    // The bounding box.
    double m_x1, m_y1, m_z1;
    double m_x2, m_y2, m_z2;

    // The properties
    dsColor_c *m_color;
    dsString m_linestyle;
    dsLineWeight_e m_lineweight;
    dsString m_textstyle;
};

#endif // TEXTINSERTER_H
