#ifndef FUNCTIONINSERTLINE_H
#define FUNCTIONINSERTLINE_H

#include "../LispFunctionBase.h"
#include "../miscellaneous.h"
#include "../Options.h"

class FunctionInsertLine : public LispFunctionBase
{
public:
    FunctionInsertLine() : LispFunctionBase(Options::instance().application) {}
    const dsString groupName() const { return Options::instance().ApiUuid; }
    const dsString functionName() const { return L"insertline"; }
    const dsString description() const { return
        L"<p>Inserts a line from two given points.</p>"
        L"<p>Usage example: (insertline 0.0 0.0 0.0 10.0 10.0 0.0)</p>";
    }
    bool ExecuteFunctionNotify();
};

#endif // FUNCTIONINSERTLINE_H
