#include "dsCommandMessage_c.h"
#include "FunctionInsertLine.h"

bool FunctionInsertLine::ExecuteFunctionNotify()
{
    dsObjectPtrArray arguments;
    dsLispParameter_ptr pReturn;
    dsCommandMessage_ptr commandline;
    application->GetCommandMessage(&commandline);

    m_function->GetArguments( &arguments );
    m_function->CreateReturnValue( &pReturn );

    if( !pReturn )
        return false;

    if( arguments.getSize() != 6 )
    {
        commandline->PrintLine(L"Incorrect number of parameters");
        pReturn->SetToNil();
        m_function->SetReturnValue( pReturn );
        return false;
    }

    unsigned int i, iSize = arguments.getSize();
    double coords[ 3 ] = { 0.0, 0.0, 0.0 };
    double coords1[ 3 ] = { 0.0, 0.0, 0.0 };

    for( i = 0; i < iSize; i++ )
    {
        dsLispParameter_ptr pParam ( static_cast< dsLispParameter_c* >( arguments[ i ] ) );
        dsLispParameterType_e type;
        pParam->get_Type( &type );

        if(i < 3)
        {
            if( type == dsLispParameterType_Double )
            {
                pParam->GetDouble( &coords[ i % 3 ] );
            }
        }
        else
        {
            if( type == dsLispParameterType_Double )
            {
                pParam->GetDouble( &coords1[ i % 3 ] );
            }
        }
    }

    pReturn->SetToVoid( );
    m_function->SetReturnValue( pReturn );

    //Now create line based on point1 and point2 
    dsDocument_ptr pDoc;
    application->GetActiveDocument(&pDoc);
    dsModel_c* model = 0;
    pDoc->GetModel(&model);
    dsSketchManager_c *dsSketchMgr;
    model->GetSketchManager(&dsSketchMgr);
    dsLine_ptr dsLine;
    dsSketchMgr->InsertLine( coords[0], coords[1], coords[2], coords1[0], coords1[1], coords1[2], &dsLine);

    //Zoom extents
    dsDoubleArray LowerLeftArray;
    LowerLeftArray.add(0);
    dsDoubleArray UpperRightArray;
    UpperRightArray.add(0);
    application->Zoom(dsZoomRange_Fit, LowerLeftArray, UpperRightArray);

    return true;
}
